/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.util.WaterloggableHelpers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;

public class BlockTurtle
extends BlockComputerBase<TileTurtle>
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape DEFAULT_SHAPE = Shapes.m_83048_((double)0.125, (double)0.125, (double)0.125, (double)0.875, (double)0.875, (double)0.875);
    private final BlockEntityTicker<TileTurtle> clientTicker = (level, pos, state, computer) -> computer.clientTick();

    public BlockTurtle(BlockBehaviour.Properties settings, ComputerFamily family, RegistryObject<BlockEntityType<TileTurtle>> type) {
        super(settings, family, type);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WaterloggableHelpers.WATERLOGGED});
    }

    @Nonnull
    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    @Nonnull
    @Deprecated
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        Vec3 vec3;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileTurtle) {
            TileTurtle turtle = (TileTurtle)tile;
            vec3 = turtle.getRenderOffset(1.0f);
        } else {
            vec3 = Vec3.f_82478_;
        }
        Vec3 offset = vec3;
        return offset.equals((Object)Vec3.f_82478_) ? DEFAULT_SHAPE : DEFAULT_SHAPE.m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext placement) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placement.m_8125_())).m_61124_((Property)WaterloggableHelpers.WATERLOGGED, (Comparable)Boolean.valueOf(WaterloggableHelpers.getFluidStateForPlacement(placement)));
    }

    @Nonnull
    @Deprecated
    public FluidState m_5888_(@Nonnull BlockState state) {
        return WaterloggableHelpers.getFluidState(state);
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction side, @Nonnull BlockState otherState, @Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockPos otherPos) {
        WaterloggableHelpers.updateShape(state, world, pos);
        return state;
    }

    @Override
    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity entity, @Nonnull ItemStack stack) {
        super.m_6402_(world, pos, state, entity, stack);
        BlockEntity tile = world.m_7702_(pos);
        if (!world.f_46443_ && tile instanceof TileTurtle) {
            TurtleSide[] turtleSideArray;
            TileTurtle turtle = (TileTurtle)tile;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                turtle.setOwningPlayer(player.m_36316_());
            }
            if ((turtleSideArray = stack.m_41720_()) instanceof ITurtleItem) {
                ResourceLocation overlay;
                ITurtleItem item = (ITurtleItem)turtleSideArray;
                for (TurtleSide side : TurtleSide.values()) {
                    turtle.getAccess().setUpgrade(side, item.getUpgrade(stack, side));
                }
                turtle.getAccess().setFuelLevel(item.getFuelLevel(stack));
                int colour = item.getColour(stack);
                if (colour != -1) {
                    turtle.getAccess().setColour(colour);
                }
                if ((overlay = item.getOverlay(stack)) != null) {
                    ((TurtleBrain)turtle.getAccess()).setOverlay(overlay);
                }
            }
        }
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        Entity exploder = explosion.getExploder();
        if (this.getFamily() == ComputerFamily.ADVANCED || exploder instanceof LivingEntity || exploder instanceof AbstractHurtingProjectile) {
            return 2000.0f;
        }
        return super.getExplosionResistance(state, world, pos, explosion);
    }

    @Override
    @Nonnull
    protected ItemStack getItem(TileComputerBase tile) {
        ItemStack itemStack;
        if (tile instanceof TileTurtle) {
            TileTurtle turtle = (TileTurtle)tile;
            itemStack = TurtleItemFactory.create(turtle);
        } else {
            itemStack = ItemStack.f_41583_;
        }
        return itemStack;
    }

    @Override
    @Nullable
    public <U extends BlockEntity> BlockEntityTicker<U> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<U> type) {
        return level.f_46443_ ? BaseEntityBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)this.type.get()), this.clientTicker) : super.m_142354_(level, state, type);
    }
}

