/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.internal.cobalt;

import cc.tweaked.internal.cobalt.Constants;
import cc.tweaked.internal.cobalt.LuaThread;
import cc.tweaked.internal.cobalt.Varargs;
import java.util.Objects;

public final class UnwindThrowable
extends Throwable {
    private static final long serialVersionUID = -197039276914556877L;
    private static final UnwindThrowable suspendCache = new UnwindThrowable(Constants.NONE, null, true, true);
    private final Varargs args;
    private final LuaThread thread;
    private final boolean suspend;
    private final boolean yield;

    private UnwindThrowable(Varargs args, LuaThread thread, boolean suspend, boolean yield) {
        this.args = args;
        this.thread = thread;
        this.suspend = suspend;
        this.yield = yield;
    }

    static UnwindThrowable yield(Varargs args) {
        Objects.requireNonNull(args, "args cannot be null");
        return new UnwindThrowable(args, null, false, true);
    }

    static UnwindThrowable resume(LuaThread thread, Varargs args) {
        return new UnwindThrowable(args, thread, false, false);
    }

    static UnwindThrowable suspend() {
        return suspendCache;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    public boolean isYield() {
        return this.yield;
    }

    public Varargs getArgs() {
        if (this.suspend) {
            throw new IllegalStateException("Cannot get args for suspending");
        }
        return this.args;
    }

    public LuaThread getThread() {
        if (this.yield) {
            throw new IllegalStateException("Cannot get thread for yielding");
        }
        return this.thread;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }
}

