/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.util;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.familiar.IFamiliar;
import com.github.klikli_dev.occultism.common.item.tool.FamiliarRingItem;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;

public class FamiliarUtil {
    public static List<LivingEntity> getOwnerEnemies(LivingEntity owner, LivingEntity familiar, float range) {
        if (null == owner) {
            return new ArrayList<LivingEntity>();
        }
        LivingEntity revenge = owner.m_21188_();
        LivingEntity target = owner.m_21214_();
        ArrayList<LivingEntity> enemies = new ArrayList<LivingEntity>();
        if (FamiliarUtil.isClose(revenge, familiar, range)) {
            enemies.add(revenge);
        }
        if (FamiliarUtil.isClose(target, familiar, range)) {
            enemies.add(target);
        }
        return enemies;
    }

    private static boolean isClose(LivingEntity e, LivingEntity familiar, float range) {
        return e != null && e != familiar && e.m_20280_((Entity)familiar) < (double)range;
    }

    public static boolean isFamiliarEnabled(LivingEntity owner, EntityType<? extends IFamiliar> familiar) {
        return (Boolean)owner.getCapability(OccultismCapabilities.FAMILIAR_SETTINGS).lazyMap(c -> c.isFamiliarEnabled(familiar)).orElse((Object)false);
    }

    public static <T extends Entity> boolean hasFamiliar(LivingEntity owner, EntityType<T> type) {
        return FamiliarUtil.hasFamiliar(owner, type, f -> true);
    }

    public static <T extends Entity> boolean hasFamiliar(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        return FamiliarUtil.getFamiliar(owner, type, pred) != null;
    }

    public static <T extends Entity> List<T> getAllFamiliars(LivingEntity owner, EntityType<T> type) {
        return FamiliarUtil.getAllFamiliars(owner, type, f -> true);
    }

    public static <T extends Entity> List<T> getAllFamiliars(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        List<T> nearby = FamiliarUtil.getAllNearbyFamiliars(owner, type, pred);
        List<T> equipped = FamiliarUtil.getAllEquippedFamiliars(owner, type, pred);
        nearby.addAll(equipped);
        return nearby;
    }

    public static <T extends Entity> T getFamiliar(LivingEntity owner, EntityType<T> type) {
        return (T)FamiliarUtil.getFamiliar(owner, type, f -> true);
    }

    public static <T extends Entity> T getFamiliar(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        T familiar = FamiliarUtil.getEquippedFamiliar(owner, type, pred);
        if (familiar == null) {
            familiar = FamiliarUtil.getNearbyFamiliar(owner, type, pred);
        }
        return familiar;
    }

    public static <T extends Entity> List<T> getAllNearbyFamiliars(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        return owner.f_19853_.m_142425_(type, owner.m_20191_().m_82400_(10.0), e -> pred.test(e) && ((IFamiliar)e).getFamiliarOwner() == owner && e.m_6084_());
    }

    public static <T extends Entity> T getNearbyFamiliar(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        List<T> nearby = FamiliarUtil.getAllNearbyFamiliars(owner, type, pred);
        return (T)(nearby.isEmpty() ? null : (Entity)nearby.get(0));
    }

    public static <T extends Entity> List<T> getAllEquippedFamiliars(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        ArrayList<Entity> familiars = new ArrayList<Entity>();
        IItemHandlerModifiable curios = (IItemHandlerModifiable)CuriosApi.getCuriosHelper().getEquippedCurios(owner).orElse(null);
        if (curios == null) {
            return familiars;
        }
        for (int i = 0; i < curios.getSlots(); ++i) {
            Entity fam;
            IFamiliar familiar = FamiliarRingItem.getFamiliar(curios.getStackInSlot(i), owner.f_19853_);
            if (familiar == null || familiar.getFamiliarEntity().m_6095_() != type || !pred.test(fam = familiar.getFamiliarEntity())) continue;
            familiars.add(fam);
        }
        return familiars;
    }

    public static <T extends Entity> T getEquippedFamiliar(LivingEntity owner, EntityType<T> type, Predicate<T> pred) {
        List<T> familiars = FamiliarUtil.getAllEquippedFamiliars(owner, type, pred);
        return (T)(familiars.isEmpty() ? null : (Entity)familiars.get(0));
    }

    public static float toRads(float deg) {
        return (float)Math.toRadians(deg);
    }

    public static boolean isChristmas() {
        if (((Boolean)Occultism.CLIENT_CONFIG.visuals.disableHolidayTheming.get()).booleanValue()) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 15 || calendar.get(2) == 0 && calendar.get(5) <= 15;
    }
}

