/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.network;

import com.github.klikli_dev.occultism.api.common.data.WorkAreaSize;
import com.github.klikli_dev.occultism.common.item.spirit.BookOfCallingItem;
import com.github.klikli_dev.occultism.network.MessageBase;
import com.github.klikli_dev.occultism.util.ItemNBTUtil;
import com.github.klikli_dev.occultism.util.TextUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class MessageSetWorkAreaSize
extends MessageBase {
    public int workAreaSize;

    public MessageSetWorkAreaSize(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageSetWorkAreaSize(int workAreaSize) {
        this.workAreaSize = workAreaSize;
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41720_() instanceof BookOfCallingItem) {
            ItemNBTUtil.getSpiritEntity(stack).ifPresent(spirit -> {
                WorkAreaSize workAreaSize = WorkAreaSize.get(this.workAreaSize);
                spirit.setWorkAreaSize(workAreaSize);
                ItemNBTUtil.updateItemNBTFromEntity(stack, spirit);
                player.f_36095_.m_38946_();
                player.m_5661_((Component)Component.m_237110_((String)"item.occultism.book_of_calling.message_set_work_area_size", (Object[])new Object[]{TextUtil.formatDemonName((MutableComponent)spirit.m_7755_()), Component.m_237115_((String)workAreaSize.getDescriptionId())}), true);
            });
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.workAreaSize);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.workAreaSize = buf.readInt();
    }
}

