/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.handlers;

import com.github.klikli_dev.occultism.common.capability.DoubleJumpCapability;
import com.github.klikli_dev.occultism.common.capability.FamiliarSettingsCapability;
import com.github.klikli_dev.occultism.network.MessageSetJumps;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismCapabilities;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="occultism", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEventHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END && evt.player.m_20096_()) {
            evt.player.getCapability(OccultismCapabilities.DOUBLE_JUMP).ifPresent(cap -> cap.setJumps(0));
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent evt) {
        ServerPlayer player;
        int jumps;
        if (evt.getEntity() instanceof ServerPlayer && (jumps = (player = (ServerPlayer)evt.getEntity()).getCapability(OccultismCapabilities.DOUBLE_JUMP).map(DoubleJumpCapability::getJumps).orElse(0).intValue()) > 0) {
            OccultismPackets.sendTo(player, new MessageSetJumps(jumps));
        }
    }

    @SubscribeEvent
    public static void onEntityConstructing(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof Player) {
            if (!((Entity)evt.getObject()).getCapability(OccultismCapabilities.DOUBLE_JUMP).isPresent()) {
                evt.addCapability(OccultismCapabilities.DOUBLE_JUMP_ID, (ICapabilityProvider)new DoubleJumpCapability.Dispatcher());
            }
            if (!((Entity)evt.getObject()).getCapability(OccultismCapabilities.FAMILIAR_SETTINGS).isPresent()) {
                evt.addCapability(OccultismCapabilities.FAMILIAR_SETTINGS_ID, (ICapabilityProvider)new FamiliarSettingsCapability.Dispatcher());
            }
        }
    }
}

