/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.level.multichunk;

import com.github.klikli_dev.occultism.common.level.multichunk.IMultiChunkSubFeature;
import com.github.klikli_dev.occultism.common.level.multichunk.MultiChunkFeatureConfig;
import com.github.klikli_dev.occultism.util.Math3DUtil;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class MultiChunkFeature
extends Feature<MultiChunkFeatureConfig> {
    public final IMultiChunkSubFeature subFeature;

    public MultiChunkFeature(Codec<MultiChunkFeatureConfig> codec, IMultiChunkSubFeature subFeature) {
        super(codec);
        this.subFeature = subFeature;
    }

    protected List<BlockPos> getRootPositions(WorldGenLevel reader, ChunkGenerator generator, WorldgenRandom random, ChunkPos generatingChunk, MultiChunkFeatureConfig config) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>(1);
        for (int i = -config.maxChunksToRoot; i < config.maxChunksToRoot; ++i) {
            for (int j = -config.maxChunksToRoot; j < config.maxChunksToRoot; ++j) {
                ChunkPos currentChunk = new ChunkPos(generatingChunk.f_45578_ + i, generatingChunk.f_45579_ + j);
                random.m_190058_(reader.m_7328_(), currentChunk.f_45578_, currentChunk.f_45579_, config.featureSeedSalt);
                if (random.m_188503_(config.chanceToGenerate) != 0) continue;
                result.add(currentChunk.m_45615_().m_7918_(random.m_188503_(15), Math.min(generator.m_6331_(), config.minGenerationHeight + random.m_188503_(Math.max(0, config.maxGenerationHeight - config.minGenerationHeight))), random.m_188503_(15)));
            }
        }
        return result;
    }

    public boolean m_142674_(FeaturePlaceContext<MultiChunkFeatureConfig> context) {
        BlockPos pos = context.m_159777_();
        ChunkSource chunkSource = context.m_159774_().m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache chunkSource2 = (ServerChunkCache)chunkSource;
            ChunkPos generatingChunk = new ChunkPos(pos);
            List<BlockPos> rootPositions = this.getRootPositions(context.m_159774_(), context.m_159775_(), (WorldgenRandom)context.m_225041_(), generatingChunk, (MultiChunkFeatureConfig)context.m_159778_());
            if (rootPositions.isEmpty()) {
                return false;
            }
            boolean generatedAny = false;
            for (BlockPos rootPosition : rootPositions) {
                if (!this.subFeature.place(context.m_159774_(), context.m_159775_(), context.m_225041_(), rootPosition, Math3DUtil.bounds(generatingChunk, context.m_159775_().m_6331_()), (MultiChunkFeatureConfig)context.m_159778_())) continue;
                generatedAny = true;
            }
            return generatedAny;
        }
        return false;
    }
}

