/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.job;

import com.github.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.ServerLevelData;

public abstract class ChangeTimeJob
extends SpiritJob {
    protected int currentChangeTicks;
    protected int requiredChangeTicks;
    protected long newTime;

    public ChangeTimeJob(SpiritEntity entity, int requiredChangeTicks) {
        super(entity);
        this.requiredChangeTicks = requiredChangeTicks;
    }

    @Override
    public void onInit() {
        this.newTime = this.getNewTime();
        if (!this.isEnabled()) {
            this.entity.m_21826_().m_213846_(this.getDisabledMessage());
            this.finishChangeTime();
        }
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < 5; ++i) {
            ((ServerLevel)this.entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.entity.m_20185_() + this.entity.f_19853_.m_213780_().m_188583_(), this.entity.m_20186_() + 0.5 + this.entity.f_19853_.m_213780_().m_188583_(), this.entity.m_20189_() + this.entity.f_19853_.m_213780_().m_188583_(), 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void update() {
        super.update();
        ++this.currentChangeTicks;
        if (!this.entity.f_20911_) {
            this.entity.m_6674_(InteractionHand.MAIN_HAND);
        }
        if (this.entity.f_19853_.m_46467_() % 2L == 0L) {
            ((ServerLevel)this.entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, this.entity.m_20185_(), this.entity.m_20186_() + 0.5, this.entity.m_20189_(), 3, 0.5, 0.0, 0.0, 0.0);
        }
        if (this.isEnabled()) {
            this.updateTime();
        }
        if (this.currentChangeTicks == this.requiredChangeTicks) {
            this.finishChangeTime();
        }
    }

    @Override
    public CompoundTag writeJobToNBT(CompoundTag compound) {
        compound.m_128405_("currentChangeTicks", this.currentChangeTicks);
        compound.m_128405_("requiredChangeTicks", this.requiredChangeTicks);
        compound.m_128356_("newTime", this.newTime);
        return super.writeJobToNBT(compound);
    }

    @Override
    public void readJobFromNBT(CompoundTag compound) {
        super.readJobFromNBT(compound);
        this.currentChangeTicks = compound.m_128451_("currentChangeTicks");
        this.requiredChangeTicks = compound.m_128451_("requiredChangeTicks");
        this.newTime = compound.m_128454_("newTime");
    }

    public void updateTime() {
        ServerLevelData level = (ServerLevelData)this.entity.f_19853_.m_6106_();
        long remainingTime = this.newTime - level.m_6792_();
        int remainingTicks = Math.max(this.requiredChangeTicks - this.currentChangeTicks, 1);
        long timeChange = remainingTime / (long)remainingTicks;
        long interpolatedTime = level.m_6792_() + timeChange;
        if (interpolatedTime >= this.newTime) {
            interpolatedTime = this.newTime;
        }
        level.m_6247_(interpolatedTime);
    }

    public void finishChangeTime() {
        this.entity.f_19853_.m_5594_(null, this.entity.m_20183_(), SoundEvents.f_11736_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.entity.m_6667_(DamageSource.f_19317_);
        this.entity.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public abstract long getNewTime();

    public abstract Component getDisabledMessage();

    public abstract boolean isEnabled();
}

