/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.entity.ai.sensor;

import com.github.klikli_dev.occultism.Occultism;
import com.github.klikli_dev.occultism.common.entity.ai.BlockSorter;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.network.MessageSelectBlock;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.github.klikli_dev.occultism.registry.OccultismSensors;
import com.github.klikli_dev.occultism.registry.OccultismTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.NotNull;

public class NearestTreeSensor<E extends SpiritEntity>
extends ExtendedSensor<E> {
    public static final int DEFAULT_SCAN_RATE_TICKS = 100;
    public static final int RESCAN_EMPTY_WORK_AREA_AFTER_TICKS = 600;
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{OccultismMemoryTypes.NEAREST_TREE.get(), OccultismMemoryTypes.NON_TREE_LOGS.get()});

    public NearestTreeSensor() {
        this.setScanRate(entity -> 100);
    }

    public static boolean isTreeSoil(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(OccultismTags.TREE_SOIL);
    }

    public static boolean isLog(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(BlockTags.f_13106_);
    }

    public static boolean isLeaf(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60734_() instanceof LeavesBlock || blockState.m_204336_(BlockTags.f_13035_);
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)OccultismSensors.NEAREST_TREE.get();
    }

    protected void doTick(@NotNull ServerLevel level, @NotNull E entity) {
        if (BrainUtils.hasMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get())) {
            return;
        }
        if (BrainUtils.hasMemory(entity, OccultismMemoryTypes.NO_TREE_IN_WORK_AREA.get())) {
            return;
        }
        Set nonTreeLogs = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.NON_TREE_LOGS.get(), HashSet::new);
        Set unreachableTrees = (Set)BrainUtils.memoryOrDefault(entity, OccultismMemoryTypes.UNREACHABLE_TREES.get(), HashSet::new);
        BlockPos workAreaCenter = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.WORK_AREA_CENTER.get());
        Integer workAreaSize = (Integer)BrainUtils.getMemory(entity, OccultismMemoryTypes.WORK_AREA_SIZE.get());
        if (Occultism.DEBUG.debugAI) {
            for (BlockPos tree : unreachableTrees) {
                OccultismPackets.sendToTracking(entity, new MessageSelectBlock(tree, 10000, 16753920));
            }
            for (BlockPos tree : nonTreeLogs) {
                OccultismPackets.sendToTracking(entity, new MessageSelectBlock(tree, 10000, 16753920));
            }
        }
        Stream<BlockPos> blocksInWorkArea = BlockPos.m_121990_((BlockPos)workAreaCenter.m_7918_(-workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2, -workAreaSize.intValue() / 2), (BlockPos)workAreaCenter.m_7918_(workAreaSize / 2, workAreaSize / 2, workAreaSize / 2)).map(BlockPos::m_7949_);
        List potentialStumps = blocksInWorkArea.filter(pos -> NearestTreeSensor.isLog((Level)level, pos) && NearestTreeSensor.isTreeSoil((Level)level, pos.m_7495_()) && !nonTreeLogs.contains(pos) && !unreachableTrees.contains(pos)).collect(Collectors.toList());
        boolean foundTree = false;
        if (!potentialStumps.isEmpty()) {
            potentialStumps.sort(new BlockSorter((Entity)entity));
            for (BlockPos potentialStump : potentialStumps) {
                if (Occultism.DEBUG.debugAI) {
                    OccultismPackets.sendToTracking(entity, new MessageSelectBlock(potentialStump, 5000, 0xFFFFFF));
                }
                if (this.isTree((Level)level, potentialStump)) {
                    boolean isReachable = false;
                    for (Direction facing : Direction.Plane.HORIZONTAL) {
                        BlockPos pos2 = potentialStump.m_121945_(facing);
                        if (!level.m_46859_(pos2)) continue;
                        isReachable = true;
                        break;
                    }
                    if (!isReachable) continue;
                    if (Occultism.DEBUG.debugAI) {
                        OccultismPackets.sendToTracking(entity, new MessageSelectBlock(potentialStump, 50000, 0x800080));
                    }
                    BrainUtils.setMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get(), (Object)potentialStump);
                    foundTree = true;
                    break;
                }
                nonTreeLogs.add(potentialStump);
                BrainUtils.setMemory(entity, OccultismMemoryTypes.NON_TREE_LOGS.get(), (Object)nonTreeLogs);
                if (!Occultism.DEBUG.debugAI) continue;
                OccultismPackets.sendToTracking(entity, new MessageSelectBlock(potentialStump, 50000, 0xFFFF00));
            }
        }
        if (!foundTree) {
            BrainUtils.clearMemory(entity, OccultismMemoryTypes.NEAREST_TREE.get());
            BrainUtils.setForgettableMemory(entity, OccultismMemoryTypes.NO_TREE_IN_WORK_AREA.get(), (Object)true, (int)600);
        }
    }

    private boolean isTree(Level level, BlockPos potentialStump) {
        if (NearestTreeSensor.isLog(level, potentialStump)) {
            BlockPos topOfTree = new BlockPos((Vec3i)potentialStump);
            while (!level.m_46859_(topOfTree.m_7494_()) && topOfTree.m_123342_() < level.m_151558_()) {
                topOfTree = topOfTree.m_7494_();
            }
            if (NearestTreeSensor.isLeaf(level, topOfTree)) {
                BlockPos logPos = this.getStump(level, topOfTree);
                return NearestTreeSensor.isLog(level, logPos);
            }
        }
        return false;
    }

    private BlockPos getStump(Level level, BlockPos log) {
        for (BlockPos pos : BlockPos.m_121990_((BlockPos)log.m_7918_(-4, -4, -4), (BlockPos)log.m_7918_(4, 0, 4)).map(BlockPos::m_7949_).toList()) {
            if (!NearestTreeSensor.isLog(level, pos.m_7495_()) && !NearestTreeSensor.isLeaf(level, pos.m_7495_())) continue;
            return this.getStump(level, pos.m_7495_());
        }
        return log;
    }
}

