/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container.storage;

import com.github.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.github.klikli_dev.occultism.common.item.storage.StorageRemoteItem;
import com.github.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.github.klikli_dev.occultism.network.MessageUpdateLinkedMachines;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import com.github.klikli_dev.occultism.util.CuriosUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class StorageRemoteContainer
extends StorageControllerContainerBase {
    protected int selectedSlot;

    public StorageRemoteContainer(int id, Inventory playerInventory, int selectedSlot) {
        super((MenuType)OccultismContainers.STORAGE_REMOTE.get(), id, playerInventory);
        this.playerInventory = playerInventory;
        this.selectedSlot = selectedSlot;
        this.matrix = new StorageControllerCraftingInventory((AbstractContainerMenu)this, this.getCraftingMatrixFromItemStack(this.getStorageRemote()));
        this.orderInventory.m_6836_(0, this.getOrderStackFromItemStack(this.getStorageRemote()));
        this.setupCraftingOutput();
        this.setupCraftingGrid();
        this.setupOrderInventorySlot();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
        this.m_6199_((Container)this.matrix);
    }

    public ItemStack getStorageRemote() {
        if (this.selectedSlot == -1) {
            return CuriosUtil.getStorageRemoteCurio(this.player);
        }
        if (this.selectedSlot < 0 || this.selectedSlot >= this.player.m_150109_().m_6643_()) {
            return ItemStack.f_41583_;
        }
        ItemStack selected = this.player.m_150109_().m_8020_(this.selectedSlot);
        return selected.m_41720_() instanceof StorageRemoteItem ? selected : ItemStack.f_41583_;
    }

    @Override
    public GlobalBlockPos getStorageControllerGlobalBlockPos() {
        ItemStack storageRemote = this.getStorageRemote();
        return storageRemote != ItemStack.f_41583_ ? GlobalBlockPos.from(this.getStorageRemote().m_41783_().m_128469_("linkedStorageController")) : null;
    }

    @Override
    protected void setupPlayerHotbar() {
        int hotbarTop = 232;
        int hotbarLeft = 56;
        for (int i = 0; i < 9; ++i) {
            if (i == this.selectedSlot) {
                this.m_38897_(new Slot((Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop){

                    public boolean m_5857_(ItemStack stack) {
                        return false;
                    }

                    public boolean m_6657_() {
                        return false;
                    }

                    public boolean m_8010_(Player playerIn) {
                        return false;
                    }
                });
                continue;
            }
            this.m_38897_(new Slot((Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    public boolean m_6875_(Player entityPlayer) {
        IStorageController storageController = this.getStorageController();
        if (storageController != null && !entityPlayer.f_19853_.f_46443_ && entityPlayer.f_19853_.m_46467_() % 40L == 0L) {
            OccultismPackets.sendTo((ServerPlayer)this.player, this.getStorageController().getMessageUpdateStacks());
            OccultismPackets.sendTo((ServerPlayer)this.player, new MessageUpdateLinkedMachines(this.getStorageController().getLinkedMachines()));
        }
        return storageController != null && this.getStorageRemote() != ItemStack.f_41583_;
    }

    @Override
    public IStorageController getStorageController() {
        return StorageRemoteItem.getStorageController(this.getStorageRemote(), this.playerInventory.f_35978_.f_19853_);
    }

    @Override
    public boolean isContainerItem() {
        return true;
    }

    @Override
    public void updateCraftingSlots(boolean force) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.matrix.m_6643_(); ++i) {
            nbtTagList.add((Object)this.matrix.m_8020_(i).serializeNBT());
        }
        ItemStack storageRemote = this.getStorageRemote();
        if (storageRemote != ItemStack.f_41583_) {
            storageRemote.m_41784_().m_128365_("craftingMatrix", (Tag)nbtTagList);
        }
    }

    @Override
    public void updateOrderSlot(boolean force) {
        ItemStack storageRemote = this.getStorageRemote();
        if (storageRemote != ItemStack.f_41583_) {
            storageRemote.m_41784_().m_128365_("orderStack", (Tag)this.orderInventory.m_8020_(0).serializeNBT());
        }
    }

    protected List<ItemStack> getCraftingMatrixFromItemStack(ItemStack stack) {
        ArrayList<ItemStack> craftingMatrix = new ArrayList<ItemStack>(Collections.nCopies(9, ItemStack.f_41583_));
        if (!stack.m_41784_().m_128441_("craftingMatrix")) {
            return craftingMatrix;
        }
        ListTag nbtTagList = stack.m_41783_().m_128437_("craftingMatrix", 10);
        for (int i = 0; i < nbtTagList.size(); ++i) {
            craftingMatrix.set(i, ItemStack.m_41712_((CompoundTag)nbtTagList.m_128728_(i)));
        }
        return craftingMatrix;
    }

    protected ItemStack getOrderStackFromItemStack(ItemStack stack) {
        if (!stack.m_41784_().m_128441_("orderStack")) {
            return ItemStack.f_41583_;
        }
        return ItemStack.m_41712_((CompoundTag)stack.m_41783_().m_128469_("orderStack"));
    }
}

