/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.common.container.storage;

import com.github.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.github.klikli_dev.occultism.common.blockentity.StableWormholeBlockEntity;
import com.github.klikli_dev.occultism.common.blockentity.StorageControllerBlockEntity;
import com.github.klikli_dev.occultism.common.container.storage.StorageControllerContainerBase;
import com.github.klikli_dev.occultism.common.misc.StorageControllerCraftingInventory;
import com.github.klikli_dev.occultism.network.MessageUpdateLinkedMachines;
import com.github.klikli_dev.occultism.network.OccultismPackets;
import com.github.klikli_dev.occultism.registry.OccultismContainers;
import com.github.klikli_dev.occultism.util.BlockEntityUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class StableWormholeContainer
extends StorageControllerContainerBase {
    protected StorageControllerBlockEntity storageController;
    protected StableWormholeBlockEntity stableWormhole;

    public StableWormholeContainer(int id, Inventory playerInventory, StableWormholeBlockEntity stableWormhole) {
        super((MenuType)OccultismContainers.STABLE_WORMHOLE.get(), id, playerInventory);
        this.stableWormhole = stableWormhole;
        this.storageController = (StorageControllerBlockEntity)stableWormhole.getLinkedStorageController();
        this.matrix = new StorageControllerCraftingInventory((AbstractContainerMenu)this, stableWormhole.getMatrix());
        this.orderInventory.m_6836_(0, this.stableWormhole.getOrderStack());
        this.setupCraftingOutput();
        this.setupCraftingGrid();
        this.setupOrderInventorySlot();
        this.setupPlayerInventorySlots();
        this.setupPlayerHotbar();
        this.m_6199_((Container)this.matrix);
    }

    public StableWormholeBlockEntity getStableWormhole() {
        return this.stableWormhole;
    }

    @Override
    protected void setupPlayerHotbar() {
        int hotbarTop = 232;
        int hotbarLeft = 56;
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.playerInventory, i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    @Override
    public StorageControllerBlockEntity getStorageController() {
        return this.storageController;
    }

    @Override
    public GlobalBlockPos getStorageControllerGlobalBlockPos() {
        return this.stableWormhole.getLinkedStorageControllerPosition();
    }

    @Override
    public boolean isContainerItem() {
        return false;
    }

    @Override
    public void updateCraftingSlots(boolean force) {
        for (int i = 0; i < 9; ++i) {
            this.stableWormhole.getMatrix().put(i, this.matrix.m_8020_(i));
        }
        if (force) {
            this.stableWormhole.markNetworkDirty();
        }
    }

    @Override
    public void updateOrderSlot(boolean force) {
        this.stableWormhole.setOrderStack(this.orderInventory.m_8020_(0));
        if (force) {
            this.stableWormhole.markNetworkDirty();
        }
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        return slot.f_40218_ != this.result && super.m_5882_(stack, slot);
    }

    public boolean m_6875_(Player player) {
        BlockPos wormholePosition;
        if (this.storageController == null || this.stableWormhole == null) {
            return false;
        }
        Level level = this.stableWormhole.m_58904_();
        if (level.m_7702_(wormholePosition = this.stableWormhole.m_58899_()) != this.stableWormhole) {
            return false;
        }
        if (BlockEntityUtil.get(level, this.stableWormhole.getLinkedStorageControllerPosition()) != this.storageController) {
            return false;
        }
        if (!level.f_46443_ && level.m_46467_() % 40L == 0L) {
            OccultismPackets.sendTo((ServerPlayer)player, this.storageController.getMessageUpdateStacks());
            OccultismPackets.sendTo((ServerPlayer)player, new MessageUpdateLinkedMachines(this.storageController.getLinkedMachines()));
        }
        return player.m_20275_((double)wormholePosition.m_123341_() + 0.5, (double)wormholePosition.m_123342_() + 0.5, (double)wormholePosition.m_123343_() + 0.5) <= 64.0;
    }
}

