/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.render.entity;

import com.github.klikli_dev.occultism.client.model.entity.MummyFamiliarModel;
import com.github.klikli_dev.occultism.common.entity.familiar.MummyFamiliarEntity;
import com.github.klikli_dev.occultism.registry.OccultismModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class MummyFamiliarRenderer
extends MobRenderer<MummyFamiliarEntity, MummyFamiliarModel> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("occultism", "textures/entity/mummy_familiar.png");

    public MummyFamiliarRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MummyFamiliarModel(context.m_174023_(OccultismModelLayers.FAMILIAR_MUMMY)), 0.3f);
        this.m_115326_(new KapowLayer(this, context));
        this.m_115326_(new EyesLayer((RenderLayerParent<MummyFamiliarEntity, MummyFamiliarModel>)this));
    }

    public ResourceLocation getTextureLocation(MummyFamiliarEntity entity) {
        return TEXTURES;
    }

    private static class KapowLayer
    extends RenderLayer<MummyFamiliarEntity, MummyFamiliarModel> {
        private static final ResourceLocation KAPOW_TEXTURE = new ResourceLocation("occultism", "textures/entity/kapow.png");
        private static final Component KAPOW_TEXT = Component.m_237115_((String)"dialog.occultism.mummy.kapow");
        private static KapowModel model;
        private final MummyFamiliarRenderer renderer;

        public KapowLayer(MummyFamiliarRenderer renderer, EntityRendererProvider.Context context) {
            super((RenderLayerParent)renderer);
            this.renderer = renderer;
            if (model == null) {
                model = new KapowModel(context.m_174023_(OccultismModelLayers.KAPOW));
            }
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, MummyFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.getFightPose() == -1) {
                return;
            }
            float alpha = pLivingEntity.getCapowAlpha(pPartialTicks);
            pMatrixStack.m_85836_();
            float scale = 0.5f;
            pMatrixStack.m_85841_(scale, scale, scale);
            Vec3 capowPos = pLivingEntity.getCapowPosition(pPartialTicks);
            pMatrixStack.m_85837_(capowPos.f_82479_, -0.4 + capowPos.f_82480_, capowPos.f_82481_);
            model.m_7695_(pMatrixStack, pBuffer.m_6299_(model.m_103119_(KAPOW_TEXTURE)), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
            pMatrixStack.m_85836_();
            pMatrixStack.m_85841_(0.07f, 0.07f, 0.07f);
            pMatrixStack.m_85837_(0.0, -2.5, 0.0);
            pMatrixStack.m_85845_(new Quaternion(0.0f, 0.0f, 20.0f, true));
            Font font = this.renderer.m_114481_();
            pMatrixStack.m_85836_();
            pMatrixStack.m_85837_(0.0, 0.0, -0.01);
            Matrix4f matrix = pMatrixStack.m_85850_().m_85861_();
            font.m_92841_(KAPOW_TEXT, (float)(-font.m_92852_((FormattedText)KAPOW_TEXT) / 2), 0.0f, 0xFF0000 | (int)(alpha * 255.0f) << 24, true, matrix, pBuffer, false, 0, pPackedLight);
            pMatrixStack.m_85849_();
            pMatrixStack.m_85836_();
            pMatrixStack.m_85837_(0.0, 0.0, 0.01);
            pMatrixStack.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
            matrix = pMatrixStack.m_85850_().m_85861_();
            font.m_92841_(KAPOW_TEXT, (float)(-font.m_92852_((FormattedText)KAPOW_TEXT) / 2), 0.0f, 0xFF0000 | (int)(alpha * 255.0f) << 24, true, matrix, pBuffer, false, 0, pPackedLight);
            pMatrixStack.m_85849_();
            pMatrixStack.m_85849_();
            pMatrixStack.m_85849_();
        }
    }

    private static class EyesLayer
    extends RenderLayer<MummyFamiliarEntity, MummyFamiliarModel> {
        private static final ResourceLocation EYES = new ResourceLocation("occultism", "textures/entity/mummy_familiar_eyes.png");

        public EyesLayer(RenderLayerParent<MummyFamiliarEntity, MummyFamiliarModel> parent) {
            super(parent);
        }

        public void render(PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight, MummyFamiliarEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float ppPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
            if (pLivingEntity.m_20145_()) {
                return;
            }
            int light = pLivingEntity.isSitting() ? 0 : 10;
            MummyFamiliarModel model = (MummyFamiliarModel)this.m_117386_();
            VertexConsumer ivertexbuilder = pBuffer.m_6299_(RenderType.m_110452_((ResourceLocation)EYES));
            model.m_7695_(pMatrixStack, ivertexbuilder, LightTexture.m_109885_((int)light, (int)light), LivingEntityRenderer.m_115338_((LivingEntity)pLivingEntity, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class KapowModel
    extends Model {
        public ModelPart kapow;

        public KapowModel(ModelPart part) {
            super(RenderType::m_110473_);
            this.kapow = part.m_171324_("kapow");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition mesh = new MeshDefinition();
            PartDefinition parts = mesh.m_171576_();
            PartDefinition body = parts.m_171599_("kapow", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171506_(-16.0f, -16.0f, 0.0f, 32.0f, 32.0f, 0.0f, false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)32);
        }

        public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
            this.kapow.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha);
        }
    }
}

