/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.spirit;

import com.github.klikli_dev.occultism.client.gui.controls.LabelWidget;
import com.github.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.github.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.github.klikli_dev.occultism.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class SpiritGui<T extends SpiritContainer>
extends AbstractContainerScreen<T> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("occultism", "textures/gui/inventory_spirit.png");
    protected static final String TRANSLATION_KEY_BASE = "gui.occultism.spirit";
    protected SpiritEntity spirit;
    protected T container;

    public SpiritGui(T container, Inventory playerInventory, Component titleIn) {
        super(container, playerInventory, titleIn);
        this.container = container;
        this.spirit = ((SpiritContainer)((Object)this.container)).spirit;
        this.f_97726_ = 175;
        this.f_97727_ = 165;
    }

    public static void drawEntityToGui(PoseStack poseStack, int posX, int posY, int scale, float mouseX, float mouseY, LivingEntity entity) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float f1 = (float)Math.atan(mouseY / 40.0f);
        poseStack.m_85836_();
        poseStack.m_85837_((double)posX, (double)posY, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        poseStack.m_85837_(0.0, 0.0, 1000.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(f1 * 20.0f);
        quaternion.m_80148_(quaternion1);
        poseStack.m_85845_(quaternion);
        float f2 = entity.f_20883_;
        float f3 = entity.f_19859_;
        float f4 = entity.f_19860_;
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + f * 20.0f;
        entity.f_19859_ = 180.0f + f * 40.0f;
        entity.f_19860_ = -f1 * 20.0f;
        entity.f_20885_ = entity.f_19859_;
        entity.f_20886_ = entity.f_19859_;
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        quaternion1.m_80157_();
        entityrenderermanager.m_114412_(quaternion1);
        entityrenderermanager.m_114468_(false);
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        entityrenderermanager.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
        entityrenderermanager.m_114468_(true);
        entity.f_20883_ = f2;
        entity.f_19859_ = f3;
        entity.f_19860_ = f4;
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        poseStack.m_85849_();
    }

    public void m_7856_() {
        String jobID;
        super.m_7856_();
        this.m_169413_();
        int labelHeight = 9;
        LabelWidget nameLabel = new LabelWidget(this.f_97735_ + 65, this.f_97736_ + 17, false, -1, 2, 0x404040);
        nameLabel.addLine(TextUtil.formatDemonName(this.spirit.m_7755_().getString()));
        this.m_142416_((GuiEventListener)nameLabel);
        if (this.spirit.getSpiritMaxAge() >= 0) {
            int agePercent = (int)Math.floor((float)this.spirit.getSpiritAge() / (float)this.spirit.getSpiritMaxAge() * 100.0f);
            LabelWidget ageLabel = new LabelWidget(this.f_97735_ + 65, this.f_97736_ + 17 + labelHeight + 5, false, -1, 2, 0x404040);
            ageLabel.addLine(I18n.m_118938_((String)"gui.occultism.spirit.age", (Object[])new Object[]{agePercent}));
            this.m_142416_((GuiEventListener)ageLabel);
        }
        if (!StringUtils.isBlank((CharSequence)(jobID = this.spirit.getJobID()))) {
            String[] lines;
            jobID = jobID.replace(":", ".");
            LabelWidget jobLabel = new LabelWidget(this.f_97735_ + 65, this.f_97736_ + 17 + labelHeight + 5 + labelHeight + 5 + 5, false, -1, 2, 0x404040);
            String jobText = I18n.m_118938_((String)"gui.occultism.spirit.job", (Object[])new Object[]{I18n.m_118938_((String)("job." + jobID), (Object[])new Object[0])});
            for (String line : lines = WordUtils.wrap((String)jobText, (int)15, (String)"\n", (boolean)true).split("[\\r\\n]+", 2)) {
                jobLabel.addLine(ChatFormatting.ITALIC + line + ChatFormatting.RESET);
            }
            this.m_142416_((GuiEventListener)jobLabel);
        }
    }

    protected void m_7027_(PoseStack pPoseStack, int pMouseX, int pMouseY) {
    }

    protected void m_7286_(PoseStack poseStack, float partialTicks, int x, int y) {
        this.m_7333_(poseStack);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        poseStack.m_85836_();
        int scale = 30;
        SpiritGui.drawEntityToGui(poseStack, this.f_97735_ + 35, this.f_97736_ + 65, scale, this.f_97735_ + 51 - x, this.f_97736_ + 75 - 50 - y, (LivingEntity)this.spirit);
        poseStack.m_85849_();
    }
}

