/*
 * Decompiled with CFR 0.152.
 */
package com.github.klikli_dev.occultism.client.gui.controls;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;

public class LabelWidget
extends AbstractWidget {
    public List<String> lines = new ArrayList<String>();
    public boolean centered = false;
    public boolean rightAligned = false;
    public int f_93618_ = 0;
    public int margin = 2;
    public boolean shadow = false;

    public LabelWidget(int xIn, int yIn) {
        this(xIn, yIn, false);
    }

    public LabelWidget(int xIn, int yIn, boolean centered) {
        this(xIn, yIn, centered, -1, -1);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height) {
        this(xIn, yIn, centered, width, height, 2);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height, int margin) {
        this(xIn, yIn, centered, width, height, margin, 0xFFFFFF);
    }

    public LabelWidget(int xIn, int yIn, boolean centered, int width, int height, int margin, int color) {
        super(xIn, yIn, width, height, (Component)Component.m_237113_((String)""));
        this.centered = centered;
        this.f_93618_ = width;
        this.margin = margin;
        this.packedFGColor = color;
        this.f_93623_ = false;
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_93624_) {
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontrenderer = minecraft.f_91062_;
            RenderSystem.m_69424_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            if (this.centered && this.f_93618_ <= 0 && this.lines.size() > 0) {
                this.f_93618_ = fontrenderer.m_92895_(this.lines.get(0));
            }
            int color = this.getFGColor();
            for (int i = 0; i < this.lines.size(); ++i) {
                Objects.requireNonNull(fontrenderer);
                int top = this.f_93621_ + i * (9 + this.margin);
                if (this.centered) {
                    this.drawCenteredLabelString(stack, fontrenderer, this.lines.get(i), this.f_93620_, top, color);
                    continue;
                }
                if (this.rightAligned) {
                    this.drawRightAlignedLabelString(stack, fontrenderer, this.lines.get(i), this.f_93620_, top, color);
                    continue;
                }
                this.drawLabelString(stack, fontrenderer, this.lines.get(i), this.f_93620_, top, color);
            }
        }
    }

    public void drawCenteredLabelString(PoseStack stack, Font fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.m_92750_(stack, text, (float)(x - fontRenderer.m_92895_(text) / 2), (float)y, color);
        } else {
            fontRenderer.m_92883_(stack, text, (float)(x - fontRenderer.m_92895_(text) / 2), (float)y, color);
        }
    }

    public void drawRightAlignedLabelString(PoseStack stack, Font fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.m_92750_(stack, text, (float)(x - fontRenderer.m_92895_(text)), (float)y, color);
        } else {
            fontRenderer.m_92883_(stack, text, (float)(x - fontRenderer.m_92895_(text)), (float)y, color);
        }
    }

    public void drawLabelString(PoseStack stack, Font fontRenderer, String text, int x, int y, int color) {
        if (this.shadow) {
            fontRenderer.m_92750_(stack, text, (float)x, (float)y, color);
        } else {
            fontRenderer.m_92883_(stack, text, (float)x, (float)y, color);
        }
    }

    public LabelWidget alignRight(boolean align) {
        this.rightAligned = align;
        if (this.rightAligned) {
            this.centered = false;
        }
        return this;
    }

    public void addLine(String string, boolean translate) {
        if (translate) {
            this.addLine(I18n.m_118938_((String)string, (Object[])new Object[0]));
        } else {
            this.addLine(string);
        }
    }

    public void addLine(String string) {
        this.lines.add(string);
    }

    public void addLine(Component component) {
        this.lines.add(component.getString());
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }
}

