/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.CrashReport;
import net.minecraft.FileUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class GuiMainMenuExtensionDevWorld {
    private static final String WORLD_NAME_PREFIX = "cyclops-dev";

    @SubscribeEvent
    public static void onMainMenuInit(ScreenEvent.Init event) {
        if (GeneralConfig.devWorldButton && event.getScreen() instanceof TitleScreen) {
            event.addListener((GuiEventListener)new Button(event.getScreen().f_96543_ / 2 + 102, event.getScreen().f_96544_ / 4 + 48, 58, 20, (Component)Component.m_237115_((String)"general.cyclopscore.dev_world"), button -> {
                String saveName;
                Minecraft mc = Minecraft.m_91087_();
                if (!MinecraftHelpers.isShifted()) {
                    LevelSummary devWorldSummary = null;
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                    try {
                        List levelList = (List)((CompletableFuture)mc.m_91392_().m_230813_(mc.m_91392_().m_230833_()).exceptionally(p_233202_ -> {
                            mc.m_231412_(CrashReport.m_127521_((Throwable)p_233202_, (String)"Couldn't load level list"));
                            return List.of();
                        })).get(5000L, TimeUnit.MILLISECONDS);
                        for (LevelSummary worldSummary : levelList) {
                            if (!worldSummary.m_78361_().equals(WORLD_NAME_PREFIX) || devWorldSummary != null && devWorldSummary.m_78366_() >= worldSummary.m_78366_()) continue;
                            devWorldSummary = worldSummary;
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException | LevelStorageException e) {
                        CyclopsCore.clog(Level.ERROR, "Couldn't load level list" + e.getMessage());
                        mc.m_91152_((Screen)new ErrorScreen((Component)Component.m_237115_((String)"selectWorld.unable_to_load"), (Component)Component.m_237113_((String)e.getMessage())));
                    }
                    if (devWorldSummary != null && mc.m_91392_().m_78255_(devWorldSummary.m_78358_())) {
                        mc.m_91346_((Screen)new GenericDirtMessageScreen((Component)Component.m_237115_((String)"selectWorld.data_read")));
                        mc.m_231466_().m_233133_(event.getScreen(), devWorldSummary.m_78358_());
                        return;
                    }
                }
                GameRules gameRules = new GameRules();
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46140_)).m_46246_(false, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46156_)).m_46246_(true, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46124_)).m_46246_(false, null);
                ((GameRules.BooleanValue)gameRules.m_46170_(GameRules.f_46125_)).m_46246_(false, null);
                LevelSettings worldsettings = new LevelSettings(WORLD_NAME_PREFIX, GameType.CREATIVE, false, Difficulty.PEACEFUL, true, gameRules, DataPackConfig.f_45842_);
                int seed = new Random().nextInt();
                RegistryAccess.Frozen dynamicRegistries = (RegistryAccess.Frozen)RegistryAccess.f_123049_.get();
                WorldGenSettings generatorSettings = ((WorldPreset)dynamicRegistries.m_175515_(Registry.f_235726_).m_206081_(WorldPresets.f_226438_).m_203334_()).m_226421_((long)seed, false, false);
                try {
                    saveName = FileUtil.m_133730_((Path)mc.m_91392_().m_78257_(), (String)WORLD_NAME_PREFIX, (String)"");
                }
                catch (IOException e) {
                    saveName = "World";
                }
                mc.m_231466_().m_233157_(saveName, worldsettings, (RegistryAccess)dynamicRegistries, generatorSettings);
            }));
        }
    }
}

