/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block.multi;

import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.block.multi.SizeValidators;
import org.cyclops.cyclopscore.helper.LocationHelpers;

public class MaximumSizeValidator
implements ISizeValidator {
    private final Vec3i maximumSize;

    @Override
    public Component isSizeValid(Vec3i size) {
        if (SizeValidators.compareVec3i(size, this.getMaximumSize()) <= 0) {
            return null;
        }
        return Component.m_237110_((String)"multiblock.cyclopscore.error.size.max", (Object[])new Object[]{LocationHelpers.toCompactString(size), LocationHelpers.toCompactString(this.getMaximumSize())});
    }

    public MaximumSizeValidator(Vec3i maximumSize) {
        this.maximumSize = maximumSize;
    }

    public Vec3i getMaximumSize() {
        return this.maximumSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaximumSizeValidator)) {
            return false;
        }
        MaximumSizeValidator other = (MaximumSizeValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vec3i this$maximumSize = this.getMaximumSize();
        Vec3i other$maximumSize = other.getMaximumSize();
        return !(this$maximumSize == null ? other$maximumSize != null : !this$maximumSize.equals(other$maximumSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MaximumSizeValidator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vec3i $maximumSize = this.getMaximumSize();
        result = result * 59 + ($maximumSize == null ? 43 : $maximumSize.hashCode());
        return result;
    }

    public String toString() {
        return "MaximumSizeValidator(maximumSize=" + this.getMaximumSize() + ")";
    }
}

