/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.util;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.computer.ComputerSide;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class CoordUtil {
    public static boolean isInRange(@NotNull BlockPos pos, @NotNull Level world, @NotNull Player player, int range) {
        if (pos == null || world == null || player == null) {
            return false;
        }
        range = Math.min(range, (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get());
        return world.m_45955_(TargetingConditions.m_148353_(), null, new AABB(pos.m_7918_(range, range, range), pos.m_7918_(-range, -range, -range))).contains(player);
    }

    public static boolean isInRange(@NotNull BlockPos pos, @NotNull Level world, @NotNull Player player, int x, int y, int z) {
        if (pos == null || world == null || player == null) {
            return false;
        }
        x = Math.min(x * 2, (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get());
        y = Math.min(y * 2, (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get());
        z = Math.min(z * 2, (Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get());
        return world.m_45955_(TargetingConditions.m_148353_(), null, new AABB(pos.m_7918_(x, y, z), pos.m_7918_(-x, -y, -z))).contains(player);
    }

    public static boolean isInRange(@NotNull BlockPos blockPos, @NotNull Player player, @NotNull Level world, @NotNull BlockPos firstPos, @NotNull BlockPos secondPos) {
        double j;
        if (blockPos == null || world == null || player == null) {
            return false;
        }
        double i = player.m_20185_() - (double)blockPos.m_123341_();
        if (Math.sqrt(i * i + (j = player.m_20189_() - (double)blockPos.m_123343_()) * j) > (double)((Integer)APConfig.PERIPHERALS_CONFIG.playerDetMaxRange.get()).intValue()) {
            return false;
        }
        return world.m_45955_(TargetingConditions.m_148353_(), null, new AABB(firstPos, secondPos)).contains(player);
    }

    public static Direction getDirection(FrontAndTop orientation, String computerSide) throws LuaException {
        if (Direction.m_122402_((String)computerSide) != null) {
            return Direction.m_122402_((String)computerSide);
        }
        Direction top = orientation.m_122629_();
        Direction front = orientation.m_122625_();
        if (front.m_122434_() == Direction.Axis.Y) {
            if (front == Direction.UP) {
                if (Objects.equals(computerSide, ComputerSide.FRONT.toString())) {
                    return Direction.UP;
                }
                if (Objects.equals(computerSide, ComputerSide.BACK.toString())) {
                    return Direction.DOWN;
                }
            }
            if (front == Direction.DOWN) {
                if (Objects.equals(computerSide, ComputerSide.FRONT.toString())) {
                    return Direction.DOWN;
                }
                if (Objects.equals(computerSide, ComputerSide.BACK.toString())) {
                    return Direction.UP;
                }
            }
            if (Objects.equals(computerSide, ComputerSide.TOP.toString())) {
                return top;
            }
            if (Objects.equals(computerSide, ComputerSide.BOTTOM.toString())) {
                return top.m_122424_();
            }
            if (Objects.equals(computerSide, ComputerSide.RIGHT.toString())) {
                return top.m_122427_();
            }
            if (Objects.equals(computerSide, ComputerSide.LEFT.toString())) {
                return top.m_122428_();
            }
        }
        if (Objects.equals(computerSide, ComputerSide.FRONT.toString())) {
            return front;
        }
        if (Objects.equals(computerSide, ComputerSide.BACK.toString())) {
            return front.m_122424_();
        }
        if (Objects.equals(computerSide, ComputerSide.TOP.toString())) {
            return Direction.UP;
        }
        if (Objects.equals(computerSide, ComputerSide.BOTTOM.toString())) {
            return Direction.DOWN;
        }
        if (Objects.equals(computerSide, ComputerSide.RIGHT.toString())) {
            return front.m_122428_();
        }
        if (Objects.equals(computerSide, ComputerSide.LEFT.toString())) {
            return front.m_122427_();
        }
        throw new LuaException(computerSide + " is not a valid side");
    }
}

