/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.refinedstorage;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.Action;
import de.srendi.advancedperipherals.common.addons.refinedstorage.RefinedStorage;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.IStorageSystemFluidHandler;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class RsFluidHandler
implements IStorageSystemFluidHandler {
    @NotNull
    private final INetwork network;

    public RsFluidHandler(@NotNull INetwork network) {
        this.network = network;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty()) {
            return 0;
        }
        return resource.getAmount() - this.network.insertFluid(resource, resource.getAmount(), action == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM).getAmount();
    }

    @Override
    @NotNull
    public FluidStack drain(FluidFilter filter, IFluidHandler.FluidAction simulate) {
        FluidStack fluid = RefinedStorage.findFluidFromFilter(this.network, null, filter);
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        return this.network.extractFluid(fluid, filter.getCount(), filter.getNbt() != null ? 1 : 0, simulate == IFluidHandler.FluidAction.SIMULATE ? Action.SIMULATE : Action.PERFORM);
    }
}

