/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.peripheral;

import appeng.api.networking.IGridNode;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.MEStorage;
import com.google.common.collect.UnmodifiableIterator;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.AppEngApi;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.CraftJob;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.MeFluidHandler;
import de.srendi.advancedperipherals.common.addons.appliedenergistics.MeItemHandler;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.BlockEntityPeripheralOwner;
import de.srendi.advancedperipherals.common.blocks.blockentities.MeBridgeEntity;
import de.srendi.advancedperipherals.common.configuration.APConfig;
import de.srendi.advancedperipherals.common.util.Pair;
import de.srendi.advancedperipherals.common.util.ServerWorker;
import de.srendi.advancedperipherals.common.util.inventory.FluidFilter;
import de.srendi.advancedperipherals.common.util.inventory.FluidUtil;
import de.srendi.advancedperipherals.common.util.inventory.InventoryUtil;
import de.srendi.advancedperipherals.common.util.inventory.ItemFilter;
import de.srendi.advancedperipherals.lib.peripherals.BasePeripheral;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class MeBridgePeripheral
extends BasePeripheral<BlockEntityPeripheralOwner<MeBridgeEntity>> {
    public static final String PERIPHERAL_TYPE = "meBridge";
    private final MeBridgeEntity tile;
    private IGridNode node;

    public MeBridgePeripheral(MeBridgeEntity tileEntity) {
        super(PERIPHERAL_TYPE, new BlockEntityPeripheralOwner<MeBridgeEntity>(tileEntity));
        this.tile = tileEntity;
        this.node = tileEntity.getActionableNode();
    }

    public void setNode(IManagedGridNode node) {
        this.node = node.getNode();
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)APConfig.PERIPHERALS_CONFIG.enableMEBridge.get();
    }

    private ICraftingService getCraftingService() {
        return this.node.getGrid().getCraftingService();
    }

    protected MethodResult exportToChest(@NotNull IArguments arguments, @NotNull IItemHandler targetInventory) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        MeItemHandler itemHandler = new MeItemHandler(monitor, this.tile);
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveItem(itemHandler, targetInventory, filter.getLeft()), null});
    }

    protected MethodResult exportToTank(@NotNull IArguments arguments, @NotNull IFluidHandler targetTank) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        MeFluidHandler fluidHandler = new MeFluidHandler(monitor, this.tile);
        Pair<FluidFilter, String> filter = FluidFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveFluid(fluidHandler, targetTank, filter.getLeft()), null});
    }

    protected MethodResult importToME(@NotNull IArguments arguments, @NotNull IItemHandler targetInventory) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        MeItemHandler itemHandler = new MeItemHandler(monitor, this.tile);
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveItem(targetInventory, itemHandler, filter.getLeft()), null});
    }

    protected MethodResult importToME(@NotNull IArguments arguments, @NotNull IFluidHandler targetTank) throws LuaException {
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        MeFluidHandler fluidHandler = new MeFluidHandler(monitor, this.tile);
        Pair<FluidFilter, String> filter = FluidFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{0, filter.getRight()});
        }
        return MethodResult.of((Object[])new Object[]{InventoryUtil.moveFluid(targetTank, fluidHandler, filter.getLeft()), null});
    }

    private MethodResult notConnected() {
        return MethodResult.of((Object[])new Object[]{null, "NOT_CONNECTED"});
    }

    @LuaFunction(mainThread=true)
    public final boolean isConnected() {
        return this.node.getGrid() != null && this.node.hasGridBooted();
    }

    @LuaFunction
    public final MethodResult craftItem(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{false, "EMPTY_FILTER"});
        }
        String cpuName = arguments.optString(1, "");
        ICraftingCPU target = this.getCraftingCPU(cpuName);
        if (!cpuName.isEmpty() && target == null) {
            return MethodResult.of((Object[])new Object[]{false, "CPU " + cpuName + " does not exists"});
        }
        ICraftingService craftingGrid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        Pair<Long, AEItemKey> stack = AppEngApi.findAEStackFromFilter(AppEngApi.getMonitor(this.tile.getGridNode()), craftingGrid, filter.getLeft());
        if (stack.getRight() == null && stack.getLeft() == 0L) {
            return MethodResult.of((Object[])new Object[]{null, "NOT_CRAFTABLE"});
        }
        CraftJob job = new CraftJob(((BlockEntityPeripheralOwner)this.owner).getLevel(), computer, this.node, stack.getRight(), parsedFilter.getCount(), this.tile, this.tile, target);
        this.tile.addJob(job);
        ServerWorker.add(job::startCrafting);
        return MethodResult.of((Object)true);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getEnergyUsage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getAvgPowerUsage());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getEnergyStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getStoredPower());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getAvgPowerUsage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getAvgPowerUsage());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getAvgPowerInjection() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getAvgPowerInjection());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getMaxEnergyStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)this.node.getGrid().getEnergyService().getMaxStoredPower());
    }

    @LuaFunction(mainThread=true)
    public final MethodResult isItemCrafting(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        ICraftingService grid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{false, "EMPTY_FILTER"});
        }
        String cpuName = arguments.optString(1, "");
        ICraftingCPU craftingCPU = this.getCraftingCPU(cpuName);
        return MethodResult.of((Object)AppEngApi.isItemCrafting(monitor, grid, parsedFilter, craftingCPU));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult isItemCraftable(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{false, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{false, "EMPTY_FILTER"});
        }
        AEItemKey item = AEItemKey.of((ItemStack)parsedFilter.toItemStack());
        return MethodResult.of((Object)this.getCraftingService().isCraftable((AEKey)item));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult exportFluid(@NotNull IArguments arguments) throws LuaException {
        IFluidHandler handler = FluidUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.exportToTank(arguments, handler);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult exportFluidToPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IFluidHandler handler = FluidUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.exportToTank(arguments, handler);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult importFluid(IArguments arguments) throws LuaException {
        IFluidHandler handler = FluidUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.importToME(arguments, handler);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult importFluidFromPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        IFluidHandler handler = FluidUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.importToME(arguments, handler);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult exportItem(@NotNull IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.exportToChest(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult exportItemToPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.exportToChest(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult importItem(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromDirection(arguments.getString(1), this.owner);
        return this.importToME(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult importItemFromPeripheral(IComputerAccess computer, IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        IItemHandler inventory = InventoryUtil.getHandlerFromName(computer, arguments.getString(1));
        return this.importToME(arguments, inventory);
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getItem(IArguments arguments) throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        MEStorage monitor = AppEngApi.getMonitor(this.node);
        Pair<ItemFilter, String> filter = ItemFilter.parse(arguments.getTable(0));
        if (filter.rightPresent()) {
            return MethodResult.of((Object[])new Object[]{null, filter.getRight()});
        }
        ItemFilter parsedFilter = filter.getLeft();
        if (parsedFilter.isEmpty()) {
            return MethodResult.of((Object[])new Object[]{null, "EMPTY_FILTER"});
        }
        return MethodResult.of(AppEngApi.getObjectFromStack(AppEngApi.findAEStackFromFilter(monitor, this.getCraftingService(), parsedFilter), this.getCraftingService()));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listItems() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of(AppEngApi.listStacks(AppEngApi.getMonitor(this.node), this.getCraftingService(), 0));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listCraftableItems() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of(AppEngApi.listStacks(AppEngApi.getMonitor(this.node), this.getCraftingService(), 2));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listFluid() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of(AppEngApi.listFluids(AppEngApi.getMonitor(this.node), this.getCraftingService(), 0));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listCraftableFluid() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of(AppEngApi.listFluids(AppEngApi.getMonitor(this.node), this.getCraftingService(), 2));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getTotalItemStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)AppEngApi.getTotalItemStorage(this.node));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getTotalFluidStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)AppEngApi.getTotalFluidStorage(this.node));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getUsedItemStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)AppEngApi.getUsedItemStorage(this.node));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getUsedFluidStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)AppEngApi.getUsedFluidStorage(this.node));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableItemStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)AppEngApi.getAvailableItemStorage(this.node));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getAvailableFluidStorage() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of((Object)AppEngApi.getAvailableFluidStorage(this.node));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult listCells() {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        return MethodResult.of(AppEngApi.listCells(this.node));
    }

    @LuaFunction(mainThread=true)
    public final MethodResult getCraftingCPUs() throws LuaException {
        if (!this.isConnected()) {
            return this.notConnected();
        }
        ICraftingService grid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        HashMap<Integer, Map<String, Object>> map = new HashMap<Integer, Map<String, Object>>();
        UnmodifiableIterator iterator = grid.getCpus().iterator();
        int i = 1;
        while (iterator.hasNext()) {
            Map<String, Object> o = AppEngApi.getObjectFromCPU((ICraftingCPU)iterator.next());
            map.put(i++, o);
        }
        return MethodResult.of(map);
    }

    public final ICraftingCPU getCraftingCPU(String cpuName) {
        if (cpuName.isEmpty()) {
            return null;
        }
        ICraftingService grid = (ICraftingService)this.node.getGrid().getService(ICraftingService.class);
        if (grid == null) {
            return null;
        }
        UnmodifiableIterator iterator = grid.getCpus().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        while (iterator.hasNext()) {
            ICraftingCPU cpu = (ICraftingCPU)iterator.next();
            if (!Objects.requireNonNull(cpu.getName()).getString().equals(cpuName)) continue;
            return cpu;
        }
        return null;
    }
}

