/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.entity;

import com.google.common.collect.ImmutableMap;
import com.izofar.bygonenether.init.ModSounds;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public class WarpedEnderMan
extends EnderMan {
    private static final int SHEAR_COOLDOWN = 20;
    private static final WarpedEnderManVariant[] VARIANTS = WarpedEnderManVariant.values();
    private static final EntityDataAccessor<Integer> VARIANT_ID = SynchedEntityData.m_135353_(WarpedEnderMan.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private WarpedEnderManVariant variant;
    private int shearCooldownCounter = 0;
    private boolean toConvertToEnderman = false;
    private static final Map<SoundEvent, SoundEvent> SOUND_MAP = ImmutableMap.of((Object)SoundEvents.f_11899_, (Object)((SoundEvent)ModSounds.WARPED_ENDERMAN_AMBIENT.get()), (Object)SoundEvents.f_11900_, (Object)((SoundEvent)ModSounds.WARPED_ENDERMAN_DEATH.get()), (Object)SoundEvents.f_11849_, (Object)((SoundEvent)ModSounds.WARPED_ENDERMAN_HURT.get()), (Object)SoundEvents.f_11850_, (Object)((SoundEvent)ModSounds.WARPED_ENDERMAN_SCREAM.get()), (Object)SoundEvents.f_11851_, (Object)((SoundEvent)ModSounds.WARPED_ENDERMAN_STARE.get()), (Object)SoundEvents.f_11852_, (Object)((SoundEvent)ModSounds.WARPED_ENDERMAN_TELEPORT.get()));

    public WarpedEnderMan(EntityType<? extends EnderMan> entityType, Level world) {
        super(entityType, world);
        this.setVariant(WarpedEnderMan.randomVariant(this.m_217043_()));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Endermite.class, true, false));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 55.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 8.5).m_22268_(Attributes.f_22277_, 64.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.shearCooldownCounter > 0) {
                --this.shearCooldownCounter;
            } else if (this.shearCooldownCounter < 0) {
                this.shearCooldownCounter = 0;
            }
            if (this.toConvertToEnderman) {
                EnderMan enderman = (EnderMan)this.m_21406_(EntityType.f_20566_, false);
                this.playShearSound(enderman);
            }
        }
    }

    public void m_5496_(SoundEvent event, float f1, float f2) {
        super.m_5496_(SOUND_MAP.getOrDefault(event, event), f1, f2);
    }

    private void playShearSound(EnderMan enderman) {
        this.f_19853_.m_6269_(null, (Entity)enderman, SoundEvents.f_12344_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT_ID, (Object)2);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.variant.ordinal());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(VARIANTS[tag.m_128451_("Variant")]);
    }

    public WarpedEnderManVariant getVariant() {
        WarpedEnderManVariant ret;
        this.variant = ret = VARIANTS[(Integer)this.f_19804_.m_135370_(VARIANT_ID)];
        return ret;
    }

    public void setVariant(WarpedEnderManVariant variant) {
        this.variant = variant;
        this.f_19804_.m_135381_(VARIANT_ID, (Object)variant.ordinal());
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42574_)) {
            if (this.isReadyForShearing() && !this.f_19853_.f_46443_) {
                boolean flag = this.toConvertToEnderman;
                this.shearWarp();
                this.m_146852_(GameEvent.f_157781_, (Entity)player);
                stack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                if (this.toConvertToEnderman && !flag && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)this);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.m_6071_(player, hand);
    }

    private boolean isReadyForShearing() {
        return this.shearCooldownCounter == 0;
    }

    private void shearWarp() {
        ItemStack itemstack = new ItemStack((ItemLike)Items.f_41908_, this.m_217043_().m_188503_(2) + 1);
        BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)itemstack, (Vec3)Vec3.f_82478_.m_82520_(0.0, 1.0, 0.0));
        this.shearCooldownCounter = 20;
        switch (this.variant) {
            case FRESH: {
                this.toConvertToEnderman = true;
                break;
            }
            case SHORT_VINE: {
                this.setVariant(WarpedEnderManVariant.FRESH);
                this.playShearSound(this);
                break;
            }
            case LONG_VINE: {
                this.setVariant(WarpedEnderManVariant.SHORT_VINE);
                this.playShearSound(this);
            }
        }
    }

    private static WarpedEnderManVariant randomVariant(RandomSource random) {
        return VARIANTS[random.m_188503_(VARIANTS.length)];
    }

    public static enum WarpedEnderManVariant {
        FRESH,
        SHORT_VINE,
        LONG_VINE;

    }
}

