/*
 * Decompiled with CFR 0.152.
 */
package com.izofar.bygonenether.client.model;

import com.google.common.collect.ImmutableList;
import com.izofar.bygonenether.entity.WitherSkeletonKnight;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class WitherSkeletonKnightModel
extends HumanoidModel<WitherSkeletonKnight> {
    private final List<ModelPart> armor;

    public WitherSkeletonKnightModel(ModelPart root) {
        super(root);
        this.armor = ImmutableList.of((Object)root.m_171324_("hat"), (Object)root.m_171324_("body").m_171324_("bodywear"), (Object)root.m_171324_("left_arm").m_171324_("left_armwear"), (Object)root.m_171324_("right_arm").m_171324_("right_armwear"), (Object)root.m_171324_("left_leg").m_171324_("left_legwear"), (Object)root.m_171324_("right_leg").m_171324_("right_legwear"));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171597_("body").m_171599_("bodywear", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171481_(-1.0f, -2.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition leftLeg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 12.0f, 2.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        leftArm.m_171599_("left_armwear", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171480_().m_171488_(3.0f, -4.0f, -1.5f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)2.0f, (float)0.0f));
        rightArm.m_171599_("right_armwear", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-9.0f, -4.0f, -1.5f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.4f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        leftLeg.m_171599_("left_legwear", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171480_().m_171488_(0.0f, -12.0f, -2.1f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.1f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.1f));
        rightLeg.m_171599_("right_legwear", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-4.0f, -12.0f, -2.1f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.1f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.1f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void prepareMobModel(WitherSkeletonKnight witherSkeletonKnight, float pitch, float yaw, float roll) {
        this.f_102816_ = HumanoidModel.ArmPose.EMPTY;
        this.f_102815_ = HumanoidModel.ArmPose.EMPTY;
        ItemStack itemstack = witherSkeletonKnight.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_150930_(Items.f_42411_) && witherSkeletonKnight.m_5912_()) {
            if (witherSkeletonKnight.m_5737_() == HumanoidArm.RIGHT) {
                this.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.m_6839_((LivingEntity)witherSkeletonKnight, pitch, yaw, roll);
    }

    public void setupAnim(WitherSkeletonKnight witherSkeletonKnight, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((LivingEntity)witherSkeletonKnight, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ItemStack itemstack = witherSkeletonKnight.m_21205_();
        if (witherSkeletonKnight.m_5912_() && (itemstack.m_41619_() || !itemstack.m_150930_(Items.f_42411_))) {
            float f = Mth.m_14031_((float)(this.f_102608_ * (float)Math.PI));
            float f1 = Mth.m_14031_((float)((1.0f - (1.0f - this.f_102608_) * (1.0f - this.f_102608_)) * (float)Math.PI));
            this.f_102811_.f_104205_ = 0.0f;
            this.f_102812_.f_104205_ = 0.0f;
            this.f_102811_.f_104204_ = -(0.1f - f * 0.6f);
            this.f_102812_.f_104204_ = 0.1f - f * 0.6f;
            this.f_102811_.f_104203_ = -1.5707964f;
            this.f_102812_.f_104203_ = -1.5707964f;
            this.f_102811_.f_104203_ -= f * 1.2f - f1 * 0.4f;
            this.f_102812_.f_104203_ -= f * 1.2f - f1 * 0.4f;
            AnimationUtils.m_102082_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (float)ageInTicks);
        }
        if (witherSkeletonKnight.m_6084_() && witherSkeletonKnight.isUsingShield()) {
            boolean flag = witherSkeletonKnight.m_5737_() == HumanoidArm.RIGHT;
            if (witherSkeletonKnight.getShieldHand() == InteractionHand.MAIN_HAND == flag) {
                this.poseRightArmShield();
            } else if (witherSkeletonKnight.getShieldHand() == InteractionHand.OFF_HAND == flag) {
                this.poseLeftArmShield();
            }
        }
    }

    private void poseRightArmShield() {
        this.f_102811_.f_104203_ = this.f_102811_.f_104203_ * 0.5f - 0.9424779f + 0.7853982f;
        this.f_102811_.f_104204_ = -0.5235988f;
    }

    private void poseLeftArmShield() {
        this.f_102812_.f_104203_ = this.f_102812_.f_104203_ * 0.5f - 0.9424779f + 0.7853982f;
        this.f_102812_.f_104204_ = 0.5235988f;
    }

    public void m_6002_(HumanoidArm arm, PoseStack pose) {
        float f = arm == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelpart = this.m_102851_(arm);
        modelpart.f_104200_ += f;
        modelpart.m_104299_(pose);
        modelpart.f_104200_ -= f;
    }

    public List<ModelPart> getArmor() {
        return this.armor;
    }
}

