/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.screens;

import com.vies.viescraftmachines.common.entities.machines.EntityMachineBase;
import com.vies.viescraftmachines.common.screens.slots.SlotDisable;
import com.vies.viescraftmachines.common.screens.slots.SlotInstruction;
import com.vies.viescraftmachines.common.screens.slots.SlotUpgrade;
import com.vies.viescraftmachines.util.enums.MachineType;
import com.vies.viescraftmachines.util.enums.MachineUpgrade;
import com.vies.viescraftmachines.util.init.client.InitMenuTypeVCM;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class MachineUpgradeMenu
extends AbstractContainerMenu {
    private final EntityMachineBase machine;
    private final ContainerData data;
    private final int containerRows;
    private Player interactingPlayer;
    private static int slotCount;
    public Boolean ignitionKeyWorks;
    public Boolean musicdiscWorks;
    public int offsetCalcFuelBarColors;
    public Boolean storageiteminslot;
    public int upgradeiteminslot;
    public int instructioncircuititeminslot;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT;

    public MachineUpgradeMenu(int pContainerId, Inventory inventoryIn, FriendlyByteBuf extraData) {
        this(pContainerId, inventoryIn, inventoryIn.f_35978_.f_19853_.m_6815_(extraData.readInt()), (ContainerData)new SimpleContainerData(5));
    }

    public MachineUpgradeMenu(int containerIdIn, Inventory inventoryIn, Entity mountableIn, ContainerData pData) {
        super((MenuType)InitMenuTypeVCM.MACHINE_UPGRADE_MENU.get(), containerIdIn);
        this.machine = (EntityMachineBase)mountableIn;
        this.containerRows = 7;
        this.data = pData;
        this.interactingPlayer = inventoryIn.f_35978_;
        this.ignitionKeyWorks = false;
        this.musicdiscWorks = false;
        this.offsetCalcFuelBarColors = 0;
        this.upgradeiteminslot = 0;
        this.instructioncircuititeminslot = 0;
        MachineUpgradeMenu.m_38869_((Container)this.machine, (int)128);
        this.addPlayerInventory(inventoryIn);
        this.addPlayerHotbar(inventoryIn);
        this.machine.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            if (!this.machine.getStatusPowered()) {
                this.m_38897_((Slot)new SlotUpgrade((IItemHandler)handler, this.machine.ItemslotUpgrade, 80, 25));
                this.m_38897_((Slot)new SlotInstruction((IItemHandler)handler, this.machine.ItemslotInstruction, 80, 95));
            } else {
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotUpgrade, 80, 25));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotInstruction, 80, 95));
            }
        });
        this.m_38884_(pData);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 36 + TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 36 + TE_INVENTORY_SLOT_COUNT) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 14 + i * 18 + this.containerRows * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 72 + this.containerRows * 18));
        }
    }

    public void m_6199_(Container p_40040_) {
        super.m_6199_(p_40040_);
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public boolean m_5882_(ItemStack p_40044_, Slot p_40045_) {
        return false;
    }

    public void m_6877_(Player p_40051_) {
        super.m_6877_(p_40051_);
    }

    public int getRowCount() {
        return this.containerRows;
    }

    public boolean IsMachineLocked() {
        return this.machine.getStatusLocked();
    }

    public String GetMachineOwner() {
        return this.machine.getStatusOwner();
    }

    public String GetMachineInteractingPlayer() {
        return this.interactingPlayer.m_20149_();
    }

    public int GetMachineID() {
        return this.machine.m_19879_();
    }

    public MachineType GetMachineType() {
        return MachineType.byId(this.machine.getStatusMachineType());
    }

    public boolean IsIgnitionKeyCorrect() {
        this.ignitionKeyWorks = false;
        if (!this.machine.getStatusItemStackInSlot1().m_41619_() && this.machine.getStatusItemStackInSlot1().m_41782_() && this.machine.getStatusItemStackInSlot1().m_41783_().m_128461_("tag-machine-owner_vcm").equals(this.machine.getStatusOwner())) {
            this.ignitionKeyWorks = true;
        }
        return this.ignitionKeyWorks;
    }

    public boolean IsChestInAnyStorageSlotCorrect() {
        this.storageiteminslot = false;
        if (this.machine.getStatusItemStackInSlot6().m_41619_() || !this.machine.getStatusItemStackInSlot7().m_41619_() || !this.machine.getStatusItemStackInSlot8().m_41619_() || !this.machine.getStatusItemStackInSlot9().m_41619_()) {
            this.storageiteminslot = true;
        }
        return this.storageiteminslot;
    }

    public boolean IsUpgradeInSlot() {
        return !this.machine.getStatusItemStackInSlot5().m_41619_();
    }

    public int GetUpgradeTypeInSlot() {
        this.upgradeiteminslot = MachineUpgrade.NONE.ordinal();
        if (!this.machine.getStatusItemStackInSlot5().m_41619_()) {
            for (MachineUpgrade type : MachineUpgrade.values()) {
                if (!this.machine.getStatusItemStackInSlot5().m_41720_().toString().contains(type.getName())) continue;
                this.upgradeiteminslot = type.ordinal();
            }
        }
        return this.upgradeiteminslot;
    }

    public boolean IsInstructionCircuitInSlot() {
        return !this.machine.getStatusItemStackInSlot4().m_41619_();
    }

    public int GetInstructionCircuitTypeInSlot() {
        this.instructioncircuititeminslot = MachineType.NONE.ordinal();
        if (!this.machine.getStatusItemStackInSlot4().m_41619_()) {
            for (MachineType type : MachineType.values()) {
                if (!this.machine.getStatusItemStackInSlot4().m_41720_().toString().contains(type.getName())) continue;
                this.instructioncircuititeminslot = type.ordinal();
            }
        }
        return this.instructioncircuititeminslot;
    }

    public boolean IsMachinePowered() {
        boolean isPowered = false;
        if (this.machine.getStatusPowered()) {
            isPowered = true;
        }
        return isPowered;
    }

    static {
        TE_INVENTORY_SLOT_COUNT = slotCount = 2;
    }
}

