/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.screens;

import com.vies.viescraftmachines.common.entities.machines.EntityMachineBase;
import com.vies.viescraftmachines.common.entities.machines.EntityMachineFuel;
import com.vies.viescraftmachines.common.screens.slots.SlotDisable;
import com.vies.viescraftmachines.common.screens.slots.SlotFuel;
import com.vies.viescraftmachines.common.screens.slots.SlotIgnitionKey;
import com.vies.viescraftmachines.common.screens.slots.SlotRecord;
import com.vies.viescraftmachines.common.screens.slots.SlotStorage;
import com.vies.viescraftmachines.common.screens.slots.SlotStorageHauler;
import com.vies.viescraftmachines.util.enums.MachineType;
import com.vies.viescraftmachines.util.enums.MachineUpgrade;
import com.vies.viescraftmachines.util.init.client.InitMenuTypeVCM;
import java.awt.Color;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.RecordItem;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public class MachineTypeFlyingMenu
extends AbstractContainerMenu {
    private final EntityMachineBase machine;
    private final ContainerData data;
    private final int containerRows;
    private final Player interactingPlayer;
    private static final int slotCount = 12;
    public Boolean ignitionKeyWorks;
    public Boolean musicdiscWorks;
    public int offsetCalcFuelBarColors;
    public Boolean storageiteminslot;
    public int upgradeiteminslot;
    public int instructioncircuititeminslot;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 12;

    public MachineTypeFlyingMenu(int pContainerId, Inventory inventoryIn, FriendlyByteBuf extraData) {
        this(pContainerId, inventoryIn, inventoryIn.f_35978_.f_19853_.m_6815_(extraData.readInt()), (ContainerData)new SimpleContainerData(5));
    }

    public MachineTypeFlyingMenu(int containerIdIn, Inventory inventoryIn, Entity mountableIn, ContainerData pData) {
        super((MenuType)InitMenuTypeVCM.MACHINE_TYPE_FLYING_MAIN_MENU.get(), containerIdIn);
        this.machine = (EntityMachineBase)mountableIn;
        this.containerRows = 7;
        this.data = pData;
        this.interactingPlayer = inventoryIn.f_35978_;
        this.ignitionKeyWorks = false;
        this.musicdiscWorks = false;
        this.storageiteminslot = false;
        this.offsetCalcFuelBarColors = 0;
        this.upgradeiteminslot = 0;
        this.instructioncircuititeminslot = 0;
        MachineTypeFlyingMenu.m_38869_((Container)this.machine, (int)128);
        this.addPlayerInventory(inventoryIn);
        this.addPlayerHotbar(inventoryIn);
        this.machine.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotIgnitionKey((IItemHandler)handler, this.machine.ItemslotIgnitionKey, 37, 104));
            this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotPatreon, 600, 100));
            this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotInstruction, 600, 100));
            this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotUpgrade, 600, 100));
            if (this.IsIgnitionKeyCorrect() && this.IsMachineLocked()) {
                this.ignitionKeyWorks = true;
            }
            if (this.GetMachineOwner().equals(this.GetMachineInteractingPlayer()) || this.IsIgnitionKeyCorrect() && this.IsMachineLocked() || !this.IsMachineLocked()) {
                if (this.GetInstructionCircuitTypeInSlot() == MachineType.HAULER.ordinal() || this.GetMachineType() == MachineType.HAULER) {
                    this.m_38897_((Slot)new SlotStorageHauler((IItemHandler)handler, this.machine.ItemslotStorage1, 129, 88));
                    this.m_38897_((Slot)new SlotStorageHauler((IItemHandler)handler, this.machine.ItemslotStorage2, 128, 106));
                    this.m_38897_((Slot)new SlotStorageHauler((IItemHandler)handler, this.machine.ItemslotStorage3, 147, 88));
                    this.m_38897_((Slot)new SlotStorageHauler((IItemHandler)handler, this.machine.ItemslotStorage4, 147, 106));
                } else if (this.GetInstructionCircuitTypeInSlot() == MachineType.SEA.ordinal() || this.GetMachineType() == MachineType.SEA) {
                    this.m_38897_((Slot)new SlotStorage((IItemHandler)handler, this.machine.ItemslotStorage1, 129, 97));
                    this.m_38897_((Slot)new SlotStorage((IItemHandler)handler, this.machine.ItemslotStorage2, 147, 97));
                    this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage3, 600, 88));
                    this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage4, 600, 106));
                } else {
                    this.m_38897_((Slot)new SlotStorage((IItemHandler)handler, this.machine.ItemslotStorage1, 138, 97));
                    this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage2, 600, 106));
                    this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage3, 600, 88));
                    this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage4, 600, 106));
                }
                this.m_38897_((Slot)new SlotFuel((IItemHandler)handler, this.machine.ItemslotFuel, 26, 45));
                this.m_38897_((Slot)new SlotRecord((IItemHandler)handler, this.machine.ItemslotRecord, 84, 88));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotItemFrame, 629, 56));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotItemDisplay, 647, 56));
            } else {
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage1, 600, 97));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage2, 600, 106));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage3, 600, 88));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotStorage4, 600, 106));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotFuel, 600, 45));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotRecord, 600, 88));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotItemFrame, 600, 56));
                this.m_38897_((Slot)new SlotDisable((IItemHandler)handler, this.machine.ItemslotItemDisplay, 600, 56));
            }
        });
        this.m_38884_(pData);
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 48, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 48) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 14 + i * 18 + this.containerRows * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 72 + this.containerRows * 18));
        }
    }

    public void m_6199_(Container p_40040_) {
        super.m_6199_(p_40040_);
    }

    public boolean m_6875_(Player p_38874_) {
        return true;
    }

    public boolean m_5882_(ItemStack p_40044_, Slot p_40045_) {
        return false;
    }

    public void m_6877_(Player p_40051_) {
        super.m_6877_(p_40051_);
    }

    public int getRowCount() {
        return this.containerRows;
    }

    public int GetBurnProgressTotal() {
        EntityMachineFuel fuelmachine;
        int finalint;
        int i = this.data.m_6413_(2);
        int j = this.data.m_6413_(3);
        int n = finalint = j != 0 && i != 0 ? i * 34 / j : 0;
        if (this.machine instanceof EntityMachineFuel && !(fuelmachine = (EntityMachineFuel)this.machine).IsFuelNeeded()) {
            finalint = 34;
        }
        return finalint;
    }

    public boolean IsOverallFuelLit() {
        EntityMachineFuel fuelmachine;
        Boolean fuelneeded = this.data.m_6413_(2) > 0;
        if (this.machine instanceof EntityMachineFuel && !(fuelmachine = (EntityMachineFuel)this.machine).IsFuelNeeded()) {
            return true;
        }
        return fuelneeded;
    }

    public String CalcFuelTime() {
        String answer = "";
        long totalSecs = this.data.m_6413_(2);
        long thours = totalSecs / 3600L;
        long tminutes = totalSecs % 3600L / 60L;
        long tseconds = totalSecs % 60L;
        answer = String.format("%02d:%02d:%02d", thours, tminutes, tseconds);
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            if (fuelmachine.getStatusBroken() || this.data.m_6413_(2) == 0) {
                answer = "--:--:--";
            }
            if (!fuelmachine.IsFuelNeeded()) {
                answer = "--:--:--";
            }
        }
        return answer;
    }

    public int CalcFuelBarColors() {
        int j = this.data.m_6413_(4);
        int offset = 0;
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            if (j == 0) {
                offset = 4;
            }
            if (!fuelmachine.IsFuelNeeded()) {
                offset = 8;
            }
        }
        return offset;
    }

    public String GetMachineDurabilityActive() {
        return String.valueOf(this.machine.getStatusDurabilityActive());
    }

    public String GetMachineDurabilityTotal() {
        return String.valueOf(this.machine.getStatusDurabilityTotal());
    }

    public String GetMachineEnergyActive() {
        return String.valueOf(this.machine.getStatusEnergyActive());
    }

    public String GetMachineEnergyTotal() {
        return String.valueOf(this.machine.getStatusEnergyTotal());
    }

    public int GetMachineDurabilityActiveSpacing() {
        int offset = 0;
        if (this.machine.getStatusDurabilityActive() >= 100) {
            offset = 12;
        } else if (this.machine.getStatusDurabilityActive() >= 10) {
            offset = 6;
        }
        return offset;
    }

    public int GetMachineEnergyActiveSpacing() {
        int offset = 0;
        if (this.machine.getStatusEnergyActive() >= 100) {
            offset = 12;
        } else if (this.machine.getStatusEnergyActive() >= 10) {
            offset = 6;
        }
        return offset;
    }

    public int GetDurabilityTextColor() {
        int offset = Color.WHITE.getRGB();
        if (this.machine.getStatusBroken()) {
            offset = Color.DARK_GRAY.getRGB();
        } else if (this.machine.getStatusDurabilityActive() >= 75) {
            offset = Color.WHITE.getRGB();
        } else if (this.machine.getStatusDurabilityActive() >= 50) {
            offset = Color.YELLOW.getRGB();
        } else if (this.machine.getStatusDurabilityActive() >= 25) {
            offset = Color.ORANGE.getRGB();
        } else if (this.machine.getStatusDurabilityActive() >= 0) {
            offset = Color.RED.getRGB();
        }
        return offset;
    }

    public int GetEnergyTextColor() {
        int offset = Color.WHITE.getRGB();
        if (this.machine.getStatusBroken()) {
            offset = Color.DARK_GRAY.getRGB();
        }
        return offset;
    }

    public int GetFuelTextColor() {
        int offset = Color.WHITE.getRGB();
        if (this.machine.getStatusBroken()) {
            offset = Color.DARK_GRAY.getRGB();
        }
        return offset;
    }

    public boolean IsMachineBroken() {
        return this.machine.getStatusBroken();
    }

    public boolean IsActivelyRunning() {
        if (this.machine instanceof EntityMachineFuel) {
            EntityMachineFuel fuelmachine = (EntityMachineFuel)this.machine;
            if (!fuelmachine.IsFuelNeeded()) {
                return true;
            }
            if (fuelmachine.PoweredAndHasFuel()) {
                return true;
            }
        }
        return false;
    }

    public boolean IsMachinePowered() {
        return this.machine.getStatusPowered();
    }

    public boolean IsMachineAutoRunning() {
        return this.machine.getStatusAutorun();
    }

    public boolean IsMachineLocked() {
        return this.machine.getStatusLocked();
    }

    public String GetMachineOwner() {
        return this.machine.getStatusOwner();
    }

    public String GetMachineInteractingPlayer() {
        return this.interactingPlayer.m_20149_();
    }

    public int GetMachineID() {
        return this.machine.m_19879_();
    }

    public MachineType GetMachineType() {
        return MachineType.byId(this.machine.getStatusMachineType());
    }

    public boolean IsIgnitionKeyCorrect() {
        this.ignitionKeyWorks = false;
        if (!this.machine.getStatusItemStackInSlot1().m_41619_() && this.machine.getStatusItemStackInSlot1().m_41782_() && this.machine.getStatusItemStackInSlot1().m_41783_().m_128461_("tag-machine-owner_vcm").equals(this.machine.getStatusOwner())) {
            this.ignitionKeyWorks = true;
        }
        return this.ignitionKeyWorks;
    }

    public boolean IsMusicDiscCorrect() {
        this.musicdiscWorks = false;
        this.machine.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            if (!handler.getStackInSlot(this.machine.ItemslotRecord).m_41619_() && handler.getStackInSlot(this.machine.ItemslotRecord).m_41720_() instanceof RecordItem) {
                this.musicdiscWorks = true;
            }
        });
        return this.musicdiscWorks;
    }

    public boolean IsChestInAnyStorageSlotCorrect() {
        this.storageiteminslot = false;
        if (!(this.machine.getStatusItemStackInSlot6().m_41619_() && this.machine.getStatusItemStackInSlot7().m_41619_() && this.machine.getStatusItemStackInSlot8().m_41619_() && this.machine.getStatusItemStackInSlot9().m_41619_())) {
            this.storageiteminslot = true;
        }
        return this.storageiteminslot;
    }

    public int GetUpgradeTypeInSlot() {
        this.upgradeiteminslot = MachineUpgrade.NONE.ordinal();
        if (!this.machine.getStatusItemStackInSlot5().m_41619_()) {
            for (MachineUpgrade type : MachineUpgrade.values()) {
                if (!this.machine.getStatusItemStackInSlot5().m_41720_().toString().contains(type.getName())) continue;
                this.upgradeiteminslot = type.ordinal();
            }
        }
        return this.upgradeiteminslot;
    }

    public int GetInstructionCircuitTypeInSlot() {
        this.instructioncircuititeminslot = MachineType.NONE.ordinal();
        if (!this.machine.getStatusItemStackInSlot4().m_41619_()) {
            for (MachineType type : MachineType.values()) {
                if (!this.machine.getStatusItemStackInSlot4().m_41720_().toString().contains(type.getName())) continue;
                this.instructioncircuititeminslot = type.ordinal();
            }
        }
        return this.instructioncircuititeminslot;
    }
}

