/*
 * Decompiled with CFR 0.152.
 */
package com.vies.viescraftmachines.common.items;

import com.vies.viescraftmachines.common.screens.detailingkit.DetailingKitClothMenu;
import com.vies.viescraftmachines.common.screens.detailingkit.DetailingKitFrameMenu;
import com.vies.viescraftmachines.common.screens.detailingkit.DetailingKitMetalMenu;
import com.vies.viescraftmachines.common.screens.detailingkit.DetailingKitPanelMenu;
import com.vies.viescraftmachines.util.enums.MachineTextures;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;

public class ItemDetailingKit
extends Item
implements MenuProvider {
    final Type type;

    public ItemDetailingKit(Type pType, Item.Properties propertiesIn) {
        super(propertiesIn);
        this.type = pType;
    }

    public void m_7373_(ItemStack stackIn, @Nullable Level levelIn, List<Component> listIn, TooltipFlag flagIn) {
        super.m_7373_(stackIn, levelIn, listIn, flagIn);
        Rarity test = this.m_41460_(stackIn);
        ChatFormatting color = ChatFormatting.GRAY;
        if (test == Rarity.UNCOMMON) {
            color = ChatFormatting.GOLD;
        }
        if (test == Rarity.RARE) {
            color = ChatFormatting.AQUA;
        }
        if (test == Rarity.EPIC) {
            color = ChatFormatting.DARK_PURPLE;
        }
        listIn.add((Component)Component.m_237115_((String)("item.viescraftmachines.tooltip." + stackIn.m_41720_() + ".1")).m_130940_(color));
        listIn.add((Component)Component.m_237115_((String)"viescraftmachines.space").m_130940_(color));
        if (stackIn.m_41782_()) {
            listIn.add((Component)Component.m_237115_((String)("item.viescraftmachines.tooltip." + stackIn.m_41720_() + ".2")).m_130940_(ChatFormatting.GREEN));
            listIn.add((Component)Component.m_237115_((String)("gui.viescraftmachines.hovertooltip." + MachineTextures.byId(stackIn.m_41783_().m_128451_("tag-detailing-kit-selected_vcm")).getName())).m_130940_(ChatFormatting.GREEN));
        } else {
            listIn.add((Component)Component.m_237115_((String)("item.viescraftmachines.tooltip." + stackIn.m_41720_() + ".3")).m_130940_(ChatFormatting.RED));
        }
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!pLevel.m_5776_()) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)pPlayer;
            NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)this, buf -> buf.writeItemStack(itemstack, false));
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)pLevel.m_5776_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        if (this.type == Type.PANEL) {
            return new DetailingKitPanelMenu(pContainerId, pPlayerInventory, pPlayer.m_21120_(InteractionHand.MAIN_HAND));
        }
        if (this.type == Type.METAL) {
            return new DetailingKitMetalMenu(pContainerId, pPlayerInventory, pPlayer.m_21120_(InteractionHand.MAIN_HAND));
        }
        if (this.type == Type.CLOTH) {
            return new DetailingKitClothMenu(pContainerId, pPlayerInventory, pPlayer.m_21120_(InteractionHand.MAIN_HAND));
        }
        return new DetailingKitFrameMenu(pContainerId, pPlayerInventory, pPlayer.m_21120_(InteractionHand.MAIN_HAND));
    }

    public Component m_5446_() {
        String kitType = "None";
        if (this.type == Type.PANEL) {
            kitType = "Panel Kit";
        }
        if (this.type == Type.METAL) {
            kitType = "Metal Kit";
        }
        if (this.type == Type.CLOTH) {
            kitType = "Cloth Kit";
        }
        if (this.type == Type.FRAME) {
            kitType = "Frame Kit";
        }
        return Component.m_237113_((String)kitType);
    }

    public Type getKitType() {
        return this.type;
    }

    public static enum Type {
        PANEL,
        METAL,
        CLOTH,
        FRAME;

    }
}

