/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.mixin;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.affix.AffixHelper;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"getHoverName"}, at={@At(value="RETURN")}, cancellable=true)
    public void apoth_affixItemName(CallbackInfoReturnable<Component> ci) {
        ItemStack ths = (ItemStack)this;
        CompoundTag afxData = ths.m_41737_("affix_data");
        if (afxData != null && afxData.m_128425_("name", 8)) {
            try {
                Component component = AffixHelper.getName(ths);
                ComponentContents componentContents = component.m_214077_();
                if (componentContents instanceof TranslatableContents) {
                    TranslatableContents tContents = (TranslatableContents)componentContents;
                    tContents.m_237523_()[1] = ci.getReturnValue();
                    ci.setReturnValue((Object)component);
                } else {
                    afxData.m_128473_("name");
                }
            }
            catch (Exception exception) {
                afxData.m_128473_("name");
            }
        }
    }

    @Inject(method={"getTooltipLines(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at={@At(value="INVOKE", ordinal=3, target="net/minecraft/world/item/ItemStack.shouldShowInTooltip(ILnet/minecraft/world/item/ItemStack$TooltipPart;)Z")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void apoth_tooltipMarker(@Nullable Player pPlayer, TooltipFlag pIsAdvanced, CallbackInfoReturnable<List<Component>> cir, List<Component> list) {
        if (Apotheosis.enableAdventure) {
            list.add((Component)Component.m_237113_((String)"APOTH_REMOVE_MARKER"));
        }
    }

    @Inject(method={"getTooltipLines(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/TooltipFlag;)Ljava/util/List;"}, at={@At(value="INVOKE", ordinal=1, target="net/minecraft/world/item/ItemStack.hasTag()Z")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void apoth_tooltipMarker2(@Nullable Player pPlayer, TooltipFlag pIsAdvanced, CallbackInfoReturnable<List<Component>> cir, List<Component> list) {
        if (Apotheosis.enableAdventure) {
            list.add((Component)Component.m_237113_((String)"APOTH_REMOVE_MARKER_2"));
        }
    }

    @ModifyVariable(at=@At(value="INVOKE", target="net/minecraft/world/item/ItemStack.getDamageValue()I"), method={"hurt"}, argsOnly=true, ordinal=0)
    public int swapDura(int amount, int amountCopy, RandomSource pRandom, @Nullable ServerPlayer pUser) {
        int blocked = 0;
        double chance = AffixHelper.getAffixes((ItemStack)this).values().stream().mapToDouble(inst -> inst.getDurabilityBonusPercentage(pUser)).sum();
        if (chance > 0.0) {
            for (int i = 0; i < amount; ++i) {
                if (!((double)pRandom.m_188501_() <= chance)) continue;
                ++blocked;
            }
        }
        return amount - blocked;
    }
}

