/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import shadows.apotheosis.adventure.AdventureConfig;

public enum LootCategory {
    NONE("none", (Predicate<ItemStack>)Predicates.alwaysFalse(), s -> new EquipmentSlot[0]),
    BOW("bow", s -> s.m_41720_() instanceof BowItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND)),
    CROSSBOW("crossbow", s -> s.m_41720_() instanceof CrossbowItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND)),
    PICKAXE("pickaxe", s -> s.canPerformAction(ToolActions.PICKAXE_DIG), s -> LootCategory.arr(EquipmentSlot.MAINHAND)),
    SHOVEL("shovel", s -> s.canPerformAction(ToolActions.SHOVEL_DIG), s -> LootCategory.arr(EquipmentSlot.MAINHAND)),
    HEAVY_WEAPON("heavy_weapon", new ShieldBreakerTest(), s -> LootCategory.arr(EquipmentSlot.MAINHAND)),
    HELMET("helmet", LootCategory.armorSlot(EquipmentSlot.HEAD), s -> LootCategory.arr(EquipmentSlot.HEAD)),
    CHESTPLATE("chestplate", LootCategory.armorSlot(EquipmentSlot.CHEST), s -> LootCategory.arr(EquipmentSlot.CHEST)),
    LEGGINGS("leggings", LootCategory.armorSlot(EquipmentSlot.LEGS), s -> LootCategory.arr(EquipmentSlot.LEGS)),
    BOOTS("boots", LootCategory.armorSlot(EquipmentSlot.FEET), s -> LootCategory.arr(EquipmentSlot.FEET)),
    SHIELD("shield", s -> s.canPerformAction(ToolActions.SHIELD_BLOCK), s -> LootCategory.arr(EquipmentSlot.OFFHAND)),
    TRIDENT("trident", s -> s.m_41720_() instanceof TridentItem, s -> LootCategory.arr(EquipmentSlot.MAINHAND)),
    SWORD("sword", s -> s.canPerformAction(ToolActions.SWORD_DIG) || s.m_41720_().getAttributeModifiers(EquipmentSlot.MAINHAND, s).get((Object)Attributes.f_22281_).stream().anyMatch(m -> m.m_22218_() > 0.0), s -> LootCategory.arr(EquipmentSlot.MAINHAND));

    public static final Map<String, LootCategory> BY_ID;
    public static final Codec<LootCategory> CODEC;
    private final String name;
    private final Predicate<ItemStack> validator;
    private final Function<ItemStack, EquipmentSlot[]> slotGetter;
    static final LootCategory[] VALUES;

    private LootCategory(String name, Predicate<ItemStack> validator, Function<ItemStack, EquipmentSlot[]> slotGetter) {
        this.name = name;
        this.validator = validator;
        this.slotGetter = slotGetter;
    }

    static EquipmentSlot[] arr(EquipmentSlot ... s) {
        return s;
    }

    public static LootCategory forItem(ItemStack item) {
        LootCategory override = AdventureConfig.TYPE_OVERRIDES.get(ForgeRegistries.ITEMS.getKey((Object)item.m_41720_()));
        if (override != null) {
            return override;
        }
        for (LootCategory c : VALUES) {
            if (!c.isValid(item)) continue;
            return c;
        }
        return NONE;
    }

    public String getDescId() {
        return "text.apotheosis.category." + this.name;
    }

    public String getDescIdPlural() {
        return this.getDescId() + ".plural";
    }

    public String getName() {
        return this.name;
    }

    public EquipmentSlot[] getSlots(ItemStack stack) {
        return this.slotGetter.apply(stack);
    }

    public boolean isValid(ItemStack stack) {
        return this.validator.test(stack);
    }

    public boolean isArmor() {
        return this == HELMET || this == CHESTPLATE || this == LEGGINGS || this == BOOTS;
    }

    public boolean isBreaker() {
        return this == PICKAXE || this == SHOVEL;
    }

    public boolean isRanged() {
        return this == BOW || this == CROSSBOW || this == TRIDENT;
    }

    public boolean isDefensive() {
        return this.isArmor() || this == SHIELD;
    }

    public boolean isLightWeapon() {
        return this == SWORD || this == TRIDENT;
    }

    public boolean isWeapon() {
        return this == SWORD || this == HEAVY_WEAPON || this == TRIDENT;
    }

    public boolean isWeaponOrShield() {
        return this.isLightWeapon() || this == SHIELD;
    }

    public boolean isNone() {
        return this == NONE;
    }

    private static Predicate<ItemStack> armorSlot(EquipmentSlot slot) {
        return stack -> {
            ArmorItem arm;
            Item patt5926$temp = stack.m_41720_();
            return patt5926$temp instanceof ArmorItem && (arm = (ArmorItem)patt5926$temp).m_40402_() == slot;
        };
    }

    @Nullable
    public static LootCategory byId(String name) {
        return BY_ID.get(name);
    }

    static {
        BY_ID = Arrays.stream(LootCategory.values()).collect(Collectors.toMap(LootCategory::getName, Function.identity()));
        CODEC = ExtraCodecs.m_184405_(LootCategory::getName, LootCategory::byId);
        VALUES = LootCategory.values();
    }

    private static class ShieldBreakerTest
    implements Predicate<ItemStack> {
        private ShieldBreakerTest() {
        }

        @Override
        public boolean test(ItemStack t) {
            try {
                Zombie holder;
                ItemStack shield = new ItemStack((ItemLike)Items.f_42740_);
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                Zombie attacker = server != null ? new Zombie((Level)server.m_129880_(Level.f_46428_)) : null;
                Zombie zombie = holder = server != null ? new Zombie((Level)server.m_129880_(Level.f_46428_)) : null;
                if (holder != null) {
                    holder.m_21008_(InteractionHand.OFF_HAND, shield);
                }
                return t.canDisableShield(shield, (LivingEntity)holder, (LivingEntity)attacker);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

