/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureConfig;
import shadows.apotheosis.adventure.affix.socket.gem.GemManager;
import shadows.placebo.json.WeightedJsonReloadListener;

public class GemLootModifier
extends LootModifier {
    public static final Codec<GemLootModifier> CODEC = RecordCodecBuilder.create(inst -> GemLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, GemLootModifier::new));

    protected GemLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!Apotheosis.enableAdventure) {
            return generatedLoot;
        }
        for (AdventureConfig.LootPatternMatcher m : AdventureConfig.AFFIX_ITEM_LOOT_RULES) {
            if (!m.matches(context.getQueriedLootTableId())) continue;
            if (!(context.m_230907_().m_188501_() <= m.chance())) break;
            float luck = context.m_78945_();
            ItemStack gem = GemManager.createRandomGemStack(context.m_230907_(), null, luck, WeightedJsonReloadListener.IDimensional.matches((Level)context.m_78952_()));
            generatedLoot.add((Object)gem);
            break;
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

