/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.ItemLike;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.socket.AddSocketsRecipe;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.affix.socket.gem.LegacyGem;
import shadows.apotheosis.adventure.compat.ApothSmithingCategory;

@JeiPlugin
public class AdventureJEIPlugin
implements IModPlugin {
    public static final RecipeType<UpgradeRecipe> APO_SMITHING = RecipeType.create((String)"apotheosis", (String)"smithing", AdventureModule.ApothUpgradeRecipe.class);
    private static final List<ItemStack> DUMMY_INPUTS = Arrays.asList(Items.f_42430_, Items.f_42390_, Items.f_42428_, Items.f_42469_, Items.f_42713_).stream().map(ItemStack::new).toList();

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("apotheosis", "adventure_module");
    }

    public void registerRecipes(IRecipeRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        ItemStack gem = new ItemStack((ItemLike)Apoth.Items.GEM.get());
        LegacyGem.setStoredBonus(gem, Attributes.f_22286_, new AttributeModifier("debug", 9999.0, AttributeModifier.Operation.ADDITION));
        reg.addIngredientInfo((Object)gem, (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.socketing")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Apoth.Items.GEM_DUST.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.gem_crushing")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Apoth.Items.VIAL_OF_EXTRACTION.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.gem_extraction")});
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Apoth.Items.VIAL_OF_EXPULSION.get()), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.gem_expulsion")});
        reg.addIngredientInfo(AdventureModule.RARITY_MATERIALS.values().stream().map(ItemStack::new).toList(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"info.apotheosis.salvaging")});
        ApothSmithingCategory.registerExtension(AddSocketsRecipe.class, new AddSocketsExtension());
        reg.addRecipes(APO_SMITHING, Minecraft.m_91087_().f_91073_.m_7465_().m_44013_(net.minecraft.world.item.crafting.RecipeType.f_44113_).stream().filter(r -> r instanceof AdventureModule.ApothUpgradeRecipe).toList());
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        reg.addRecipeCategories(new IRecipeCategory[]{new ApothSmithingCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    static class AddSocketsExtension
    implements ApothSmithingCategory.Extension<AddSocketsRecipe> {
        private static final List<ItemStack> DUMMY_OUTPUTS = DUMMY_INPUTS.stream().map(ItemStack::m_41777_).map(s -> {
            SocketHelper.setSockets(s, 1);
            return s;
        }).toList();

        AddSocketsExtension() {
        }

        @Override
        public void setRecipe(IRecipeLayoutBuilder builder, AddSocketsRecipe recipe, IFocusGroup focuses) {
            builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, DUMMY_INPUTS);
            builder.addSlot(RecipeIngredientRole.INPUT, 50, 1).addIngredients(recipe.getInput());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 1).addItemStacks(DUMMY_OUTPUTS);
        }

        @Override
        public void draw(AddSocketsRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
            MutableComponent text = Component.m_237110_((String)"text.apotheosis.socket_limit", (Object[])new Object[]{recipe.getMaxSockets()});
            Font font = Minecraft.m_91087_().f_91062_;
            font.m_92889_(stack, (Component)text, (float)(62 - font.m_92852_((FormattedText)text) / 2), 23.0f, 0);
        }
    }
}

