/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem.cutting;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.socket.gem.GemInstance;
import shadows.apotheosis.adventure.affix.socket.gem.cutting.GemCuttingMenu;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.screen.PlaceboContainerScreen;

public class GemCuttingScreen
extends PlaceboContainerScreen<GemCuttingMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("apotheosis", "textures/gui/gem_cutting.png");

    public GemCuttingScreen(GemCuttingMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void m_7286_(PoseStack stack, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        int xCenter = (this.f_96543_ - this.f_97726_) / 2;
        int yCenter = (this.f_96544_ - this.f_97727_) / 2;
        this.m_93228_(stack, xCenter, yCenter, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7025_(PoseStack poseStack, int pX, int pY) {
        ItemStack gemStack = ((GemCuttingMenu)this.f_97732_).m_38853_(1).m_7993_();
        GemInstance gem = new GemInstance(gemStack);
        ArrayList<Component> list = new ArrayList<Component>();
        if (gem.isValid()) {
            int dust = ((GemCuttingMenu)this.f_97732_).m_38853_(0).m_7993_().m_41613_();
            if (gem.isMaxed()) {
                if (gem.rarity() == LootRarity.ANCIENT) {
                    list.add((Component)Component.m_237115_((String)"text.apotheosis.no_upgrade").m_130944_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.YELLOW}));
                } else {
                    list.add((Component)Component.m_237115_((String)"text.apotheosis.rarity_up_cost").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                    list.add((Component)Component.m_237110_((String)"text.apotheosis.dust_cost", (Object[])new Object[]{"4x", ((Item)Apoth.Items.GEM_DUST.get()).m_7626_(ItemStack.f_41583_)}).m_130940_(dust < 4 ? ChatFormatting.RED : ChatFormatting.GRAY));
                    list.add((Component)Component.m_237110_((String)"text.apotheosis.mat_cost", (Object[])new Object[]{"1x", gemStack.m_41786_()}).m_130940_(dust < 4 ? ChatFormatting.RED : ChatFormatting.GRAY));
                }
            } else {
                boolean hasMats;
                ItemStack slotMat;
                Item rarityMat;
                list.add((Component)Component.m_237115_((String)"text.apotheosis.cut_cost").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
                list.add((Component)Component.m_237110_((String)"text.apotheosis.dust_cost", (Object[])new Object[]{"1x", ((Item)Apoth.Items.GEM_DUST.get()).m_7626_(ItemStack.f_41583_)}).m_130940_(dust < 1 ? ChatFormatting.RED : ChatFormatting.GRAY));
                list.add((Component)Component.m_237119_());
                if (gem.rarity() == LootRarity.ANCIENT) {
                    list.add((Component)Component.m_237110_((String)"text.apotheosis.mat_cost", (Object[])new Object[]{"1x", Component.m_237113_((String)"Manifestation of Infinity").m_130940_(ChatFormatting.OBFUSCATED)}).m_130940_(ChatFormatting.RED));
                } else {
                    rarityMat = (Item)AdventureModule.RARITY_MATERIALS.get((Object)gem.rarity());
                    slotMat = ((GemCuttingMenu)this.f_97732_).m_38853_(2).m_7993_();
                    hasMats = slotMat.m_41720_() == rarityMat;
                    list.add((Component)Component.m_237110_((String)"text.apotheosis.mat_cost", (Object[])new Object[]{"1x", rarityMat.m_7626_(ItemStack.f_41583_)}).m_130940_(!hasMats ? ChatFormatting.RED : ChatFormatting.GRAY));
                }
                if (gem.rarity() != LootRarity.COMMON) {
                    list.add((Component)Component.m_237113_((String)"or").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                    rarityMat = (Item)AdventureModule.RARITY_MATERIALS.get((Object)gem.rarity().prev());
                    slotMat = ((GemCuttingMenu)this.f_97732_).m_38853_(2).m_7993_();
                    hasMats = slotMat.m_41720_() == rarityMat;
                    list.add((Component)Component.m_237110_((String)"text.apotheosis.mat_cost", (Object[])new Object[]{"4x", rarityMat.m_7626_(ItemStack.f_41583_)}).m_130940_(!hasMats ? ChatFormatting.RED : ChatFormatting.GRAY));
                }
            }
        }
        this.drawOnLeft(poseStack, list, this.getGuiTop() + 30);
        super.m_7025_(poseStack, pX, pY);
    }

    public void drawOnLeft(PoseStack stack, List<Component> list, int y) {
        if (list.isEmpty()) {
            return;
        }
        int xPos = this.getGuiLeft() - 16 - list.stream().map(arg_0 -> ((Font)this.f_96547_).m_92852_(arg_0)).max(Integer::compare).get();
        int maxWidth = 9999;
        if (xPos < 0) {
            maxWidth = this.getGuiLeft() - 6;
            xPos = -8;
        }
        ArrayList split = new ArrayList();
        int lambdastupid = maxWidth;
        list.forEach(comp -> {
            if (comp.m_214077_() == ComponentContents.f_237124_) {
                split.add(comp);
            } else {
                split.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)comp, lambdastupid, comp.m_7383_()));
            }
        });
        this.renderComponentTooltip(stack, split, xPos, y, this.f_96547_);
    }
}

