/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem.bonus;

import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mojang.serialization.codecs.SimpleMapCodec;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import shadows.apotheosis.adventure.affix.socket.gem.GemClass;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public abstract class GemBonus {
    public static final SimpleMapCodec<LootRarity, StepFunction> VALUES_CODEC = Codec.simpleMap(LootRarity.CODEC, (Codec)StepFunction.CODEC, (Keyable)Keyable.forStrings(() -> LootRarity.values().stream().map(LootRarity::id)));
    protected final ResourceLocation id;
    protected final GemClass gemClass;

    public GemBonus(ResourceLocation id, GemClass gemClass) {
        this.id = id;
        this.gemClass = gemClass;
    }

    public abstract Component getSocketBonusTooltip(ItemStack var1, LootRarity var2, int var3);

    public abstract int getMaxFacets(LootRarity var1);

    public abstract GemBonus validate();

    public abstract boolean supports(LootRarity var1);

    public int getNumberOfUUIDs() {
        return 1;
    }

    public void addModifiers(ItemStack gem, LootRarity rarity, int facets, BiConsumer<Attribute, AttributeModifier> map) {
    }

    public int getDamageProtection(ItemStack gem, LootRarity rarity, int facets, DamageSource source) {
        return 0;
    }

    public float getDamageBonus(ItemStack gem, LootRarity rarity, int facets, MobType creatureType) {
        return 0.0f;
    }

    public void doPostAttack(ItemStack gem, LootRarity rarity, int facets, LivingEntity user, @Nullable Entity target) {
    }

    public void doPostHurt(ItemStack gem, LootRarity rarity, int facets, LivingEntity user, @Nullable Entity attacker) {
    }

    public void onArrowFired(ItemStack gem, LootRarity rarity, int facets, LivingEntity user, AbstractArrow arrow) {
    }

    @Nullable
    public InteractionResult onItemUse(ItemStack gem, LootRarity rarity, int facets, UseOnContext ctx) {
        return null;
    }

    public void onArrowImpact(AbstractArrow arrow, LootRarity rarity, int facets, HitResult res, HitResult.Type type) {
    }

    public float onShieldBlock(ItemStack gem, LootRarity rarity, int facets, LivingEntity entity, DamageSource source, float amount) {
        return amount;
    }

    public void onBlockBreak(ItemStack gem, LootRarity rarity, int facets, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
    }

    public float getDurabilityBonusPercentage(ItemStack gem, LootRarity rarity, int facets, ServerPlayer user) {
        return 0.0f;
    }

    public float onHurt(ItemStack gem, LootRarity rarity, int facets, DamageSource src, LivingEntity ent, float amount) {
        return amount;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public GemClass getGemClass() {
        return this.gemClass;
    }

    protected static <T extends GemBonus> App<RecordCodecBuilder.Mu<T>, GemClass> gemClass() {
        return GemClass.CODEC.fieldOf("gem_class").forGetter(gem -> gem.getGemClass());
    }
}

