/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket.gem;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import shadows.apotheosis.Apoth;
import shadows.apotheosis.Apotheosis;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;
import shadows.apotheosis.adventure.affix.socket.gem.LegacyGem;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.AttributeBonus;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.DamageReductionBonus;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.DurabilityBonus;
import shadows.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.codec.PlaceboCodecs;
import shadows.placebo.json.JsonUtil;
import shadows.placebo.json.PSerializer;
import shadows.placebo.json.WeightedJsonReloadListener;

public class GemManager
extends WeightedJsonReloadListener<Gem> {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(Attribute.class, JsonUtil.makeSerializer((IForgeRegistry)ForgeRegistries.ATTRIBUTES)).registerTypeAdapter(LootRarity.class, (Object)new LootRarity.Serializer()).create();
    public static final GemManager INSTANCE = new GemManager();
    protected final Map<ResourceLocation, Codec<? extends GemBonus>> gemBonusCodecs = new HashMap<ResourceLocation, Codec<? extends GemBonus>>();
    protected final BiMap<ResourceLocation, PSerializer<? extends GemBonus>> gemBonusSerializers = HashBiMap.create();
    private final Codec<GemBonus> gemBonusCodec = PlaceboCodecs.mapBacked((String)"Gem Bonus", this.gemBonusCodecs, GemBonus::getId);

    public GemManager() {
        super(AdventureModule.LOGGER, "gems", true, true);
        this.registerBonusCodecs();
    }

    protected void registerBuiltinSerializers() {
        this.registerSerializer(DEFAULT, PSerializer.fromCodec((String)"Gem", Gem.CODEC));
        this.registerSerializer(Apotheosis.loc("legacy"), PSerializer.builtin((String)"Legacy Gem", () -> LegacyGem.INSTANCE));
    }

    protected void registerBonusCodecs() {
        this.registerBonusCodec(Apotheosis.loc("attribute"), AttributeBonus.CODEC);
        this.registerBonusCodec(Apotheosis.loc("durability"), DurabilityBonus.CODEC);
        this.registerBonusCodec(Apotheosis.loc("damage_reduction"), DamageReductionBonus.CODEC);
    }

    protected void onReload() {
        super.onReload();
        Preconditions.checkArgument((boolean)(Apoth.Gems.LEGACY.get() instanceof LegacyGem), (Object)"Legacy Gem not registered!");
    }

    public final void registerBonusCodec(ResourceLocation id, Codec<? extends GemBonus> codec) {
        if (this.gemBonusSerializers.containsKey((Object)id)) {
            throw new RuntimeException("Attempted to register a gem bonus serializer with id " + id + " but one already exists!");
        }
        this.gemBonusCodecs.put(id, codec);
        this.gemBonusSerializers.put((Object)id, (Object)PSerializer.fromCodec((String)id.toString(), codec).build(this.synced));
    }

    public static ItemStack createRandomGemStack(RandomSource rand, @Nullable LootRarity rarity, float luck, Predicate<Gem> filter) {
        Gem gem = (Gem)INSTANCE.getRandomItem(rand, luck, filter);
        if (gem == null) {
            return ItemStack.f_41583_;
        }
        return GemManager.createGemStack(gem, rand, rarity, luck);
    }

    public static ItemStack createGemStack(Gem gem, RandomSource rand, @Nullable LootRarity rarity, float luck) {
        ItemStack stack = new ItemStack((ItemLike)Apoth.Items.GEM.get());
        GemItem.setGem(stack, gem);
        if (rarity == null) {
            rarity = LootRarity.random(rand, luck, gem);
        }
        GemItem.setLootRarity(stack, rarity);
        int facets = rand.m_188503_(gem.getMaxFacets(rarity) + 1);
        GemItem.setFacets(stack, facets);
        return stack;
    }

    public static Codec<GemBonus> gemBonusCodec() {
        return ExtraCodecs.m_184415_(() -> GemManager.INSTANCE.gemBonusCodec);
    }
}

