/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.socket;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.socket.SocketHelper;
import shadows.apotheosis.adventure.affix.socket.gem.Gem;
import shadows.apotheosis.adventure.affix.socket.gem.GemItem;

public class SocketingRecipe
extends AdventureModule.ApothUpgradeRecipe {
    private static final ResourceLocation ID = new ResourceLocation("apotheosis:socketing");

    public SocketingRecipe() {
        super(ID, Ingredient.f_43901_, Ingredient.f_43901_, ItemStack.f_41583_);
    }

    public boolean m_5818_(Container pInv, Level pLevel) {
        ItemStack gemStack = pInv.m_8020_(1);
        Gem gem = GemItem.getGemOrLegacy(gemStack);
        if (gem == null) {
            return false;
        }
        if (SocketHelper.getEmptySockets(pInv.m_8020_(0)) == 0) {
            return false;
        }
        return gem.canApplyTo(pInv.m_8020_(0), gemStack, GemItem.getLootRarity(gemStack));
    }

    public ItemStack m_5874_(Container pInv) {
        ItemStack out = pInv.m_8020_(0).m_41777_();
        if (out.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int sockets = SocketHelper.getSockets(out);
        int free = SocketHelper.getEmptySockets(out);
        List<ItemStack> gems = SocketHelper.getGems(out, sockets);
        gems.set(sockets - free, pInv.m_8020_(1));
        SocketHelper.setGems(out, gems);
        return out;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8042_() {
        return new ItemStack((ItemLike)Blocks.f_50625_);
    }

    public ResourceLocation m_6423_() {
        return ID;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44113_;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SocketingRecipe> {
        public static Serializer INSTANCE = new Serializer();

        public SocketingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            return new SocketingRecipe();
        }

        public SocketingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            return new SocketingRecipe();
        }

        public void toNetwork(FriendlyByteBuf pBuffer, SocketingRecipe pRecipe) {
        }
    }
}

