/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.salvaging;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.salvaging.SalvagingMenu;
import shadows.apotheosis.adventure.client.SimpleTexButton;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.ClientUtil;

public class SalvagingScreen
extends AbstractContainerScreen<SalvagingMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("apotheosis", "textures/gui/salvage.png");
    protected final int[] numOuts = new int[12];
    protected final ItemStack[] mats = new ItemStack[6];
    protected final TextureAtlasSprite[] sprites = new TextureAtlasSprite[6];
    protected final Component results = Component.m_237115_((String)"text.apotheosis.results");
    protected SimpleTexButton salvageBtn;

    public SalvagingScreen(SalvagingMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        ((SalvagingMenu)this.f_97732_).setButtonUpdater(this::updateButtons);
        for (int i = 0; i < 5; ++i) {
            this.mats[i] = new ItemStack((ItemLike)AdventureModule.RARITY_MATERIALS.get((Object)LootRarity.values().get(i)));
            this.sprites[i] = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("apotheosis", "items/" + ForgeRegistries.ITEMS.getKey((Object)this.mats[i].m_41720_()).m_135815_()));
        }
        --this.f_97728_;
        --this.f_97730_;
        ++this.f_97731_;
    }

    protected void m_7856_() {
        super.m_7856_();
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.salvageBtn = (SimpleTexButton)this.m_142416_((GuiEventListener)new SimpleTexButton(left + 105, top + 33, 20, 20, 196, 0, TEXTURE, 256, 256, btn -> this.f_96541_.f_91072_.m_105208_(((SalvagingMenu)this.f_97732_).f_38840_, 0), (Component)Component.m_237115_((String)"button.apotheosis.salvage")).setInactiveMessage((Component)Component.m_237115_((String)"button.apotheosis.no_salvage").m_130940_(ChatFormatting.RED)));
        this.updateButtons();
    }

    public void updateButtons() {
        if (this.salvageBtn == null) {
            return;
        }
        Arrays.fill(this.numOuts, 0);
        boolean btnActive = false;
        for (int i = 0; i < 15; ++i) {
            Slot s = ((SalvagingMenu)this.f_97732_).m_38853_(i);
            ItemStack stack = s.m_7993_();
            LootRarity rarity = AffixHelper.getRarity(stack);
            if (rarity == null) continue;
            btnActive = true;
            int ord = rarity.ordinal();
            int[] counts = SalvagingMenu.getSalvageCounts(stack);
            int n = ord * 2;
            this.numOuts[n] = this.numOuts[n] + counts[0];
            int n2 = ord * 2 + 1;
            this.numOuts[n2] = this.numOuts[n2] + counts[1];
        }
        this.salvageBtn.f_93623_ = btnActive;
    }

    public void m_6305_(PoseStack stack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(stack);
        super.m_6305_(stack, pMouseX, pMouseY, pPartialTick);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        RenderSystem.m_69478_();
        for (int i = 0; i < 5; ++i) {
            if (this.numOuts[i * 2 + 1] <= 0) continue;
            ClientUtil.colorBlit((PoseStack)stack, (int)(left + 134 + i % 2 * 18), (int)(top + 17 + i / 2 * 18), (int)100, (int)16, (int)16, (TextureAtlasSprite)this.sprites[i], (int)-1711276033);
        }
        this.m_7025_(stack, pMouseX, pMouseY);
    }

    protected void m_7286_(PoseStack pPoseStack, float pPartialTick, int pX, int pY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pPoseStack, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_7025_(PoseStack stack, int x, int y) {
        stack.m_85836_();
        stack.m_85837_(0.0, 0.0, -100.0);
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237115_((String)"text.apotheosis.salvage_results").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
        for (int i = 0; i < 5; ++i) {
            if (this.numOuts[i * 2 + 1] <= 0) continue;
            tooltip.add((Component)Component.m_237110_((String)"%s-%s %s", (Object[])new Object[]{this.numOuts[i * 2], this.numOuts[i * 2 + 1], this.mats[i].m_41786_()}));
        }
        if (tooltip.size() > 1) {
            this.drawOnLeft(stack, tooltip, this.getGuiTop() + 29);
        }
        stack.m_85849_();
        super.m_7025_(stack, x, y);
    }

    public void drawOnLeft(PoseStack stack, List<Component> list, int y) {
        if (list.isEmpty()) {
            return;
        }
        int xPos = this.getGuiLeft() - 16 - list.stream().map(arg_0 -> ((Font)this.f_96547_).m_92852_(arg_0)).max(Integer::compare).get();
        int maxWidth = 9999;
        if (xPos < 0) {
            maxWidth = this.getGuiLeft() - 6;
            xPos = -8;
        }
        ArrayList split = new ArrayList();
        int lambdastupid = maxWidth;
        list.forEach(comp -> split.addAll(this.f_96547_.m_92865_().m_92414_((FormattedText)comp, lambdastupid, comp.m_7383_())));
        this.renderComponentTooltip(stack, split, xPos, y, this.f_96547_);
    }

    protected void m_7027_(PoseStack stack, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(stack, this.results, 133.0f, (float)this.f_97729_, 0x404040);
        super.m_7027_(stack, mouseX, mouseY);
    }
}

