/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.util.StepFunction;

public class PsychicAffix
extends Affix {
    protected final Map<LootRarity, StepFunction> values;

    public PsychicAffix(Map<LootRarity, StepFunction> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        list.accept((Component)Component.m_237110_((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{PsychicAffix.fmt(100.0f * this.getTrueLevel(rarity, level))}).m_130940_(ChatFormatting.YELLOW));
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        return LootCategory.forItem(stack) == LootCategory.SHIELD && this.values.containsKey(rarity);
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        Projectile arrow;
        Entity owner;
        Entity entity2 = source.m_7640_();
        if (entity2 instanceof Projectile && (owner = (arrow = (Projectile)entity2).m_37282_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)owner;
            living.m_6469_(new EntityDamageSource("player", (Entity)entity).m_19389_(), amount * this.getTrueLevel(rarity, level));
        }
        return super.onShieldBlock(stack, rarity, level, entity, source, amount);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public static Affix read(JsonObject obj) {
        Map<LootRarity, StepFunction> values = AffixHelper.readValues(GsonHelper.m_13930_((JsonObject)obj, (String)"values"));
        return new PsychicAffix(values);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236831_(this.values, (b, key) -> b.m_130070_(key.id()), (b, func) -> func.write(b));
    }

    public static Affix read(FriendlyByteBuf buf) {
        Map values = buf.m_236847_(b -> LootRarity.byId(b.m_130277_()), b -> StepFunction.read((FriendlyByteBuf)b));
        return new PsychicAffix(values);
    }
}

