/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringUtil;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.json.JsonUtil;
import shadows.placebo.util.StepFunction;

public class PotionAffix
extends Affix {
    protected final Map<LootRarity, EffectInst> effects;
    protected final Set<LootCategory> types;
    protected final Target target;
    protected final int cooldown;

    public PotionAffix(Map<LootRarity, EffectInst> effects, Set<LootCategory> types, Target target, int cooldown) {
        super(AffixType.ABILITY);
        this.effects = effects;
        this.types = types;
        this.target = target;
        this.cooldown = cooldown;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        MobEffectInstance inst = this.effects.get(rarity).build(level);
        if (this.cooldown != 0) {
            MutableComponent cd = Component.m_237110_((String)"affix.apotheosis.cooldown", (Object[])new Object[]{StringUtil.m_14404_((int)this.cooldown)});
            list.accept((Component)Component.m_237110_((String)"%s %s", (Object[])new Object[]{this.target.toComponent(PotionAffix.toComponent(inst)), cd}).m_130940_(ChatFormatting.YELLOW));
        } else {
            list.accept((Component)this.target.toComponent(PotionAffix.toComponent(inst)).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return false;
        }
        return (this.types.isEmpty() || this.types.contains((Object)cat)) && this.effects.containsKey(rarity);
    }

    @Override
    public void doPostHurt(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity attacker) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.HURT_SELF) {
            this.applyEffect(user, inst, level);
        } else if (this.target == Target.HURT_ATTACKER && attacker instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)attacker;
            this.applyEffect(tLiving, inst, level);
        }
    }

    @Override
    public void doPostAttack(ItemStack stack, LootRarity rarity, float level, LivingEntity user, Entity target) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.ATTACK_SELF) {
            this.applyEffect(user, inst, level);
        } else if (this.target == Target.ATTACK_TARGET && target instanceof LivingEntity) {
            LivingEntity tLiving = (LivingEntity)target;
            this.applyEffect(tLiving, inst, level);
        }
    }

    @Override
    public void onBlockBreak(ItemStack stack, LootRarity rarity, float level, Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.BREAK_SELF) {
            this.applyEffect((LivingEntity)player, inst, level);
        }
    }

    @Override
    public void onArrowImpact(AbstractArrow arrow, LootRarity rarity, float level, HitResult res, HitResult.Type type) {
        Entity entity;
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.ARROW_SELF) {
            Entity entity2 = arrow.m_37282_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity2;
                this.applyEffect(owner, inst, level);
            }
        } else if (this.target == Target.ARROW_TARGET && type == HitResult.Type.ENTITY && (entity = ((EntityHitResult)res).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.applyEffect(target, inst, level);
        }
    }

    @Override
    public float onShieldBlock(ItemStack stack, LootRarity rarity, float level, LivingEntity entity, DamageSource source, float amount) {
        Entity entity2;
        EffectInst inst = this.effects.get(rarity);
        if (this.target == Target.BLOCK_SELF) {
            this.applyEffect(entity, inst, level);
        } else if (this.target == Target.BLOCK_ATTACKER && (entity2 = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity2;
            this.applyEffect(target, inst, level);
        }
        return amount;
    }

    private void applyEffect(LivingEntity target, EffectInst inst, float level) {
        long lastApplied;
        MobEffectInstance mei = inst.build(level);
        if (this.cooldown != 0 && (lastApplied = target.getPersistentData().m_128454_("apoth.affix_cooldown." + this.getId().toString())) != 0L && lastApplied + (long)this.cooldown >= target.f_19853_.m_46467_()) {
            return;
        }
        target.m_7292_(mei);
        target.getPersistentData().m_128356_("apoth.affix_cooldown." + this.getId().toString(), target.f_19853_.m_46467_());
    }

    public static Component toComponent(MobEffectInstance inst) {
        MutableComponent mutablecomponent = Component.m_237115_((String)inst.m_19576_());
        MobEffect mobeffect = inst.m_19544_();
        if (inst.m_19564_() > 0) {
            mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + inst.m_19564_()))});
        }
        if (inst.m_19557_() > 20) {
            mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_19581_((MobEffectInstance)inst, (float)1.0f)});
        }
        return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
    }

    public static PotionAffix read(JsonObject obj) {
        MobEffect effect = (MobEffect)JsonUtil.getRegistryObject((JsonObject)obj, (String)"mob_effect", (IForgeRegistry)ForgeRegistries.MOB_EFFECTS);
        Target target = Target.valueOf(GsonHelper.m_13906_((JsonObject)obj, (String)"target"));
        JsonObject valueMap = GsonHelper.m_13930_((JsonObject)obj, (String)"values");
        HashMap<LootRarity, EffectInst> effects = new HashMap<LootRarity, EffectInst>();
        for (String s : valueMap.keySet()) {
            LootRarity rarity = LootRarity.byId(s);
            JsonObject child = valueMap.get(s).getAsJsonObject();
            JsonElement dur = child.get("duration");
            StepFunction duration = dur.isJsonObject() ? (StepFunction)GSON.fromJson(dur, StepFunction.class) : StepFunction.constant((float)dur.getAsInt());
            JsonElement amp = child.get("amplifier");
            StepFunction amplifier = amp.isJsonObject() ? (StepFunction)GSON.fromJson(amp, StepFunction.class) : StepFunction.constant((float)amp.getAsInt());
            effects.put(rarity, new EffectInst(effect, duration, amplifier));
        }
        Set<LootCategory> types = AffixHelper.readTypes(GsonHelper.m_13933_((JsonObject)obj, (String)"types"));
        int cooldown = GsonHelper.m_13824_((JsonObject)obj, (String)"cooldown", (int)0);
        return new PotionAffix(effects, types, target, cooldown);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        EffectInst inst = this.effects.values().stream().findFirst().get();
        buf.writeRegistryId(ForgeRegistries.MOB_EFFECTS, (Object)inst.effect);
        buf.m_236831_(this.effects, (b, key) -> b.m_130070_(key.id()), (b, modif) -> modif.write((FriendlyByteBuf)b));
        buf.writeByte(this.types.size());
        this.types.forEach(c -> buf.m_130068_((Enum)c));
        buf.m_130068_((Enum)this.target);
        buf.writeInt(this.cooldown);
    }

    public static PotionAffix read(FriendlyByteBuf buf) {
        MobEffect effect = (MobEffect)buf.readRegistryIdSafe(MobEffect.class);
        Map effects = buf.m_236847_(b -> LootRarity.byId(b.m_130277_()), b -> EffectInst.read(effect, b));
        HashSet<LootCategory> types = new HashSet<LootCategory>();
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            types.add((LootCategory)buf.m_130066_(LootCategory.class));
        }
        Target target = (Target)buf.m_130066_(Target.class);
        int cooldown = buf.readInt();
        return new PotionAffix(effects, types, target, cooldown);
    }

    public static enum Target {
        ATTACK_SELF("attack_self"),
        ATTACK_TARGET("attack_target"),
        HURT_SELF("hurt_self"),
        HURT_ATTACKER("hurt_attacker"),
        BREAK_SELF("break_self"),
        ARROW_SELF("arrow_self"),
        ARROW_TARGET("arrow_target"),
        BLOCK_SELF("block_self"),
        BLOCK_ATTACKER("block_attacker");

        private final String id;

        private Target(String id) {
            this.id = id;
        }

        public MutableComponent toComponent(Object ... args) {
            return Component.m_237110_((String)("affix.apotheosis.target." + this.id), (Object[])args);
        }
    }

    public record EffectInst(MobEffect effect, StepFunction duration, StepFunction amplifier) {
        public MobEffectInstance build(float level) {
            return new MobEffectInstance(this.effect, this.duration.getInt(level), this.amplifier.getInt(level));
        }

        public void write(FriendlyByteBuf buf) {
            this.duration.write(buf);
            this.amplifier.write(buf);
        }

        public static EffectInst read(MobEffect effect, FriendlyByteBuf buf) {
            return new EffectInst(effect, StepFunction.read((FriendlyByteBuf)buf), StepFunction.read((FriendlyByteBuf)buf));
        }
    }
}

