/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix.effect;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.codec.EnumCodec;
import shadows.placebo.util.StepFunction;

public class DamageReductionAffix
extends Affix {
    protected final DamageType type;
    protected final Map<LootRarity, StepFunction> values;
    protected final Set<LootCategory> types;

    public DamageReductionAffix(DamageType type, Map<LootRarity, StepFunction> levelFuncs, Set<LootCategory> types) {
        super(AffixType.ABILITY);
        this.type = type;
        this.values = levelFuncs;
        this.types = types;
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(stack);
        return !cat.isNone() && (this.types.isEmpty() || this.types.contains((Object)cat)) && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
        MutableComponent comp = Component.m_237110_((String)"affix.apotheosis:damage_reduction.desc", (Object[])new Object[]{Component.m_237115_((String)("misc.apotheosis." + this.type.id)), DamageReductionAffix.fmt(100.0f * this.getTrueLevel(rarity, level))});
        comp = Component.m_237110_((String)"text.apotheosis.dot_prefix", (Object[])new Object[]{comp}).m_130940_(ChatFormatting.YELLOW);
        list.accept((Component)comp);
    }

    @Override
    public float onHurt(ItemStack stack, LootRarity rarity, float level, DamageSource src, LivingEntity ent, float amount) {
        if (src.m_19378_() || src.m_19379_()) {
            return amount;
        }
        if (this.type.test(src)) {
            return amount * (1.0f - this.getTrueLevel(rarity, level));
        }
        return super.onHurt(stack, rarity, level, src, ent, amount);
    }

    private float getTrueLevel(LootRarity rarity, float level) {
        return this.values.get(rarity).get(level);
    }

    public static DamageReductionAffix read(JsonObject obj) {
        DamageType type = DamageType.valueOf(GsonHelper.m_13906_((JsonObject)obj, (String)"damage_type"));
        Map<LootRarity, StepFunction> values = AffixHelper.readValues(GsonHelper.m_13930_((JsonObject)obj, (String)"values"));
        Set types = (Set)GSON.fromJson((JsonElement)GsonHelper.m_13832_((JsonObject)obj, (String)"types", (JsonArray)new JsonArray()), new TypeToken<Set<LootCategory>>(){}.getType());
        return new DamageReductionAffix(type, values, types);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.m_236831_(this.values, (b, key) -> b.m_130070_(key.id()), (b, func) -> func.write(b));
        buf.writeByte(this.types.size());
        this.types.forEach(c -> buf.m_130068_((Enum)c));
    }

    public static DamageReductionAffix read(FriendlyByteBuf buf) {
        DamageType type = (DamageType)buf.m_130066_(DamageType.class);
        Map values = buf.m_236847_(b -> LootRarity.byId(b.m_130277_()), b -> StepFunction.read((FriendlyByteBuf)b));
        HashSet<LootCategory> types = new HashSet<LootCategory>();
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            types.add((LootCategory)buf.m_130066_(LootCategory.class));
        }
        return new DamageReductionAffix(type, values, types);
    }

    public static enum DamageType implements Predicate<DamageSource>
    {
        PHYSICAL("physical", d -> !d.m_19387_() && !d.m_19384_() && !d.m_19372_() && !d.m_146707_()),
        MAGIC("magic", DamageSource::m_19387_),
        FIRE("fire", DamageSource::m_19384_),
        FALL("fall", DamageSource::m_146707_),
        EXPLOSION("explosion", DamageSource::m_19372_);

        public static Codec<DamageType> CODEC;
        private final String id;
        private final Predicate<DamageSource> predicate;

        private DamageType(String id, Predicate<DamageSource> predicate) {
            this.id = id;
            this.predicate = predicate;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public boolean test(DamageSource t) {
            return this.predicate.test(t);
        }

        static {
            CODEC = new EnumCodec(DamageType.class);
        }
    }
}

