/*
 * Decompiled with CFR 0.152.
 */
package shadows.apotheosis.adventure.affix;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import shadows.apotheosis.adventure.AdventureModule;
import shadows.apotheosis.adventure.affix.Affix;
import shadows.apotheosis.adventure.affix.AffixHelper;
import shadows.apotheosis.adventure.affix.AffixType;
import shadows.apotheosis.adventure.loot.LootCategory;
import shadows.apotheosis.adventure.loot.LootRarity;
import shadows.placebo.json.JsonUtil;
import shadows.placebo.util.StepFunction;

public class AttributeAffix
extends Affix {
    protected final Map<LootRarity, ModifierInst> modifiers;
    protected final Set<LootCategory> types;

    public AttributeAffix(Attribute attr, AttributeModifier.Operation op, Map<LootRarity, StepFunction> values, Set<LootCategory> types) {
        super(AffixType.STAT);
        this.modifiers = values.entrySet().stream().map(entry -> Pair.of((Object)((LootRarity)entry.getKey()), (Object)new ModifierInst(attr, op, (StepFunction)entry.getValue(), new HashMap<EquipmentSlot, UUID>()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        this.types = types;
    }

    @Override
    public void addInformation(ItemStack stack, LootRarity rarity, float level, Consumer<Component> list) {
    }

    @Override
    public void addModifiers(ItemStack stack, LootRarity rarity, float level, EquipmentSlot type, BiConsumer<Attribute, AttributeModifier> map) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            AdventureModule.LOGGER.debug("Attempted to apply the attributes of affix {} on item {}, but it is not an affix-compatible item!", (Object)this.getId(), (Object)stack.m_41786_().getString());
            return;
        }
        ModifierInst modif = this.modifiers.get(rarity);
        if (modif.attr == null) {
            AdventureModule.LOGGER.debug("The affix {} has attempted to apply a null attribute modifier to {}!", (Object)this.getId(), (Object)stack.m_41786_().getString());
            return;
        }
        for (EquipmentSlot slot : cat.getSlots(stack)) {
            if (slot != type) continue;
            map.accept(modif.attr, modif.build(slot, this.getId(), level));
        }
    }

    @Override
    public boolean canApplyTo(ItemStack stack, LootRarity rarity) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return false;
        }
        return (this.types.isEmpty() || this.types.contains((Object)cat)) && this.modifiers.containsKey(rarity);
    }

    public static AttributeAffix read(JsonObject obj) {
        Attribute attr = (Attribute)JsonUtil.getRegistryObject((JsonObject)obj, (String)"attribute", (IForgeRegistry)ForgeRegistries.ATTRIBUTES);
        AttributeModifier.Operation op = AttributeModifier.Operation.valueOf((String)GsonHelper.m_13906_((JsonObject)obj, (String)"operation"));
        Map<LootRarity, StepFunction> values = AffixHelper.readValues(GsonHelper.m_13930_((JsonObject)obj, (String)"values"));
        Set<LootCategory> types = AffixHelper.readTypes(GsonHelper.m_13933_((JsonObject)obj, (String)"types"));
        return new AttributeAffix(attr, op, values, types);
    }

    public JsonObject write() {
        return new JsonObject();
    }

    public void write(FriendlyByteBuf buf) {
        ModifierInst inst = this.modifiers.values().stream().findFirst().get();
        buf.writeRegistryId(ForgeRegistries.ATTRIBUTES, (Object)inst.attr);
        buf.m_130068_((Enum)inst.op);
        buf.m_236831_(this.modifiers, (b, key) -> b.m_130070_(key.id()), (b, modif) -> modif.valueFactory.write(b));
        buf.writeByte(this.types.size());
        this.types.forEach(c -> buf.m_130068_((Enum)c));
    }

    public static AttributeAffix read(FriendlyByteBuf buf) {
        Attribute attr = (Attribute)buf.readRegistryIdSafe(Attribute.class);
        AttributeModifier.Operation op = (AttributeModifier.Operation)buf.m_130066_(AttributeModifier.Operation.class);
        Map values = buf.m_236847_(b -> LootRarity.byId(b.m_130277_()), b -> StepFunction.read((FriendlyByteBuf)b));
        HashSet<LootCategory> types = new HashSet<LootCategory>();
        int size = buf.readByte();
        for (int i = 0; i < size; ++i) {
            types.add((LootCategory)buf.m_130066_(LootCategory.class));
        }
        return new AttributeAffix(attr, op, values, types);
    }

    public record ModifierInst(Attribute attr, AttributeModifier.Operation op, StepFunction valueFactory, Map<EquipmentSlot, UUID> cache) {
        public AttributeModifier build(EquipmentSlot slot, ResourceLocation id, float level) {
            return new AttributeModifier(this.cache.computeIfAbsent(slot, k -> UUID.randomUUID()), "affix:" + id, (double)this.valueFactory.get(level), this.op);
        }
    }
}

