/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.util.UpgradeHelper;
import java.util.Locale;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public enum UpgradeType {
    CRAFTING(false, false, 1),
    UPGRADE(false, false, 1),
    GLOWING(true, false, 15),
    UNGLOWING(false, false, 14),
    SPAWNER(true, true, 10),
    DESPAWNER(true, true, 1),
    MOB_KILLER(true, true, 3),
    LOOTING(true, true, 5),
    AUTOMATION(true, true, 1),
    SPEED(true, true, 10),
    INTERACTION(true, true, 1),
    SOUND(true, true, 1);

    private final boolean upgraded;
    private final boolean subsequentUsesSlot;
    private final int cap;

    private UpgradeType(boolean upgraded, boolean subsequentUsesSlot, int cap) {
        this.upgraded = upgraded;
        this.subsequentUsesSlot = subsequentUsesSlot;
        this.cap = cap;
    }

    public boolean isSubsequentUsesSlot() {
        return this.subsequentUsesSlot;
    }

    public boolean requiresUpgrade() {
        return this.upgraded;
    }

    public int getCap() {
        return this.cap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(ItemStack stack, int level) {
        if (this == CRAFTING) {
            return true;
        }
        if (this == UPGRADE) {
            if (stack.m_41737_("BlockEntityTag") != null) return false;
            CompoundTag entityTag = new CompoundTag();
            entityTag.m_128405_("statueLevel", 0);
            entityTag.m_128405_("statueMobKilled", 0);
            entityTag.m_128405_("upgradeSlots", 0);
            entityTag.m_128379_("statueUpgraded", true);
            stack.m_41700_("BlockEntityTag", (Tag)entityTag);
            return true;
        }
        if (!(stack.m_41720_() instanceof StatueBlockItem)) return false;
        if (this.requiresUpgrade()) {
            CompoundTag compoundtag = stack.m_41737_("BlockEntityTag");
            if (!(compoundtag != null || stack.m_41783_() != null && stack.m_41783_().m_128471_("statueUpgraded"))) {
                return false;
            }
            if (compoundtag == null) return false;
            int upgradeSlots = compoundtag.m_128451_("upgradeSlots");
            if (this.isSubsequentUsesSlot() && upgradeSlots <= 0) {
                return false;
            }
            String ID = this.name().toLowerCase(Locale.ROOT);
            String glowingID = GLOWING.name().toLowerCase(Locale.ROOT);
            String unglowingID = UNGLOWING.name().toLowerCase(Locale.ROOT);
            Map<String, Short> upgradeMap = UpgradeHelper.loadUpgradeMap(compoundtag);
            if (this == UNGLOWING && upgradeMap.getOrDefault(glowingID, (short)0) == 0) {
                return false;
            }
            short currentLevel = upgradeMap.getOrDefault(ID, (short)0);
            if (currentLevel + 1 > this.getCap()) return false;
            if (level != -1) {
                if (currentLevel != level) return false;
                if (this == UNGLOWING) {
                    if (upgradeMap.getOrDefault(glowingID, (short)0) > 0) {
                        UpgradeHelper.downgrade(upgradeMap, glowingID);
                    }
                } else if (this == GLOWING) {
                    if (upgradeMap.getOrDefault(unglowingID, (short)0) > 0) {
                        UpgradeHelper.downgrade(upgradeMap, unglowingID);
                    } else {
                        UpgradeHelper.upgrade(upgradeMap, glowingID);
                    }
                } else {
                    UpgradeHelper.upgrade(upgradeMap, ID);
                }
                if (this.isSubsequentUsesSlot()) {
                    compoundtag.m_128405_("upgradeSlots", upgradeSlots - 1);
                }
            } else {
                if (this == UNGLOWING) {
                    if (upgradeMap.getOrDefault(glowingID, (short)0) > 0) {
                        UpgradeHelper.downgrade(upgradeMap, glowingID);
                    }
                } else if (this == GLOWING) {
                    if (upgradeMap.getOrDefault(unglowingID, (short)0) > 0) {
                        UpgradeHelper.downgrade(upgradeMap, unglowingID);
                    } else {
                        UpgradeHelper.upgrade(upgradeMap, glowingID);
                    }
                } else {
                    UpgradeHelper.upgrade(upgradeMap, ID);
                }
                if (this.isSubsequentUsesSlot()) {
                    compoundtag.m_128405_("upgradeSlots", upgradeSlots - 1);
                }
            }
            UpgradeHelper.saveUpgradeMap(compoundtag, upgradeMap);
            stack.m_41700_("BlockEntityTag", (Tag)compoundtag);
            return true;
        }
        CompoundTag compoundtag = stack.m_41784_();
        compoundtag.m_128379_("statueUpgraded", true);
        compoundtag.m_128405_("statueUpgraded", 1);
        return true;
    }
}

