/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.network.message;

import com.shynieke.statues.entity.PlayerStatue;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class PlayerStatueSyncMessage {
    private final UUID entityUUID;
    private final CompoundTag data;

    private PlayerStatueSyncMessage(FriendlyByteBuf buf) {
        this.entityUUID = buf.m_130259_();
        this.data = buf.m_130260_();
    }

    public PlayerStatueSyncMessage(UUID playerUUID, CompoundTag tag) {
        this.entityUUID = playerUUID;
        this.data = tag;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
        buf.m_130079_(this.data);
    }

    public static PlayerStatueSyncMessage decode(FriendlyByteBuf packetBuffer) {
        return new PlayerStatueSyncMessage(packetBuffer.m_130259_(), packetBuffer.m_130260_());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            if (ctx.getDirection().getReceptionSide().isServer()) {
                ServerPlayer player = ctx.getSender();
                ServerLevel serverLevel = ctx.getSender().m_9236_();
                Entity entity = serverLevel.m_8791_(this.entityUUID);
                if (entity instanceof PlayerStatue) {
                    PlayerStatue playerStatue = (PlayerStatue)entity;
                    if (player != null && (!playerStatue.isLocked() || playerStatue.getLockedBy().equals(player.m_20148_()))) {
                        boolean noGravityFlag;
                        CompoundTag entityTag = playerStatue.m_20240_(new CompoundTag());
                        CompoundTag entityTagCopy = entityTag.m_6426_();
                        if (!this.data.m_128456_()) {
                            entityTagCopy.m_128391_(this.data);
                            UUID uuid = playerStatue.m_20148_();
                            playerStatue.m_20258_(entityTagCopy);
                            playerStatue.m_20084_(uuid);
                        }
                        float YOffset = this.data.m_128457_("yOffset");
                        playerStatue.setYOffset(YOffset);
                        boolean lockFlag = this.data.m_128471_("Locked");
                        if (lockFlag) {
                            if (!playerStatue.isLocked()) {
                                playerStatue.setLockedBy(player.m_20148_());
                            }
                        } else if (playerStatue.isLocked()) {
                            playerStatue.setUnlocked();
                        }
                        if (noGravityFlag = this.data.m_128471_("NoGravity")) {
                            playerStatue.m_20242_(true);
                        } else {
                            playerStatue.m_20242_(false);
                        }
                    }
                }
            }
        });
        ctx.setPacketHandled(true);
    }
}

