/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.menu;

import com.shynieke.statues.blockentities.StatueTableBlockEntity;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class StatueTableMenu
extends AbstractContainerMenu {
    private final StatueTableBlockEntity statueBE;
    private final Player player;
    public final int[] validRecipe = new int[1];

    public StatueTableMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, StatueTableMenu.getBlockEntity(playerInventory, data));
    }

    private static StatueTableBlockEntity getBlockEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null!");
        Objects.requireNonNull(data, "data cannot be null!");
        BlockEntity BlockEntityAtPos = playerInventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
        if (BlockEntityAtPos instanceof StatueTableBlockEntity) {
            return (StatueTableBlockEntity)BlockEntityAtPos;
        }
        throw new IllegalStateException("Block entity is not correct! " + BlockEntityAtPos);
    }

    public StatueTableMenu(int id, Inventory playerInventoryIn, StatueTableBlockEntity tableBlockEntity) {
        super((MenuType)StatueRegistry.STATUE_TABLE_MENU.get(), id);
        this.player = playerInventoryIn.f_35978_;
        this.statueBE = tableBlockEntity;
        this.m_38897_((Slot)new TableSlot((IItemHandler)tableBlockEntity.handler, 0, 80, 30));
        this.m_38897_((Slot)new TableSlot((IItemHandler)tableBlockEntity.handler, 1, 8, 48));
        this.m_38897_((Slot)new TableSlot((IItemHandler)tableBlockEntity.handler, 2, 62, 12));
        this.m_38897_((Slot)new TableSlot((IItemHandler)tableBlockEntity.handler, 3, 98, 12));
        this.m_38897_((Slot)new TableSlot((IItemHandler)tableBlockEntity.handler, 4, 62, 48));
        this.m_38897_((Slot)new TableSlot((IItemHandler)tableBlockEntity.handler, 5, 98, 48));
        int xPos = 8;
        int yPos = 75;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventoryIn, x + y * 9 + 9, xPos + x * 18, yPos + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventoryIn, x, xPos + x * 18, yPos + 58));
        }
        this.validRecipe[0] = this.statueBE.hasValidRecipe() ? 1 : 0;
        this.m_38895_(DataSlot.m_39406_((int[])this.validRecipe, (int)0));
    }

    public boolean m_6875_(Player playerIn) {
        return this.statueBE.stillValid(playerIn) && !playerIn.m_5833_();
    }

    @Nonnull
    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            int containerSize = 6;
            if (index < 6 ? !this.m_38903_(itemstack1, 6, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, 6, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        this.m_6199_(null);
        return itemstack;
    }

    public StatueTableBlockEntity getStatueBE() {
        return this.statueBE;
    }

    public void m_38946_() {
        super.m_38946_();
    }

    public void m_6199_(Container inventoryIn) {
        if (inventoryIn != null) {
            super.m_6199_(inventoryIn);
        }
        this.getStatueBE().m_6596_();
        if (!this.player.f_19853_.f_46443_) {
            this.validRecipe[0] = this.statueBE.hasValidRecipe() ? 1 : 0;
        }
    }

    public class TableSlot
    extends SlotItemHandler {
        public TableSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void m_6654_() {
            super.m_6654_();
            StatueTableMenu.this.m_6199_(null);
        }
    }
}

