/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.lootmodifiers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.registry.StatueTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class StatuesLootModifier
extends LootModifier {
    public static final Supplier<Codec<StatuesLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> StatuesLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, StatuesLootModifier::new)));

    public StatuesLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ITagManager itemITagManager;
        if (((Boolean)StatuesConfig.COMMON.ancientCityLoot.get()).booleanValue() && (itemITagManager = ForgeRegistries.ITEMS.tags()) != null) {
            ITag statues = itemITagManager.getTag(StatueTags.STATUES_ITEMS);
            RandomSource random = context.m_230907_();
            ItemStack statueStack = new ItemStack((ItemLike)statues.getRandomElement(random).orElse(Items.f_42521_));
            if (random.m_188500_() <= (Double)StatuesConfig.COMMON.ancientCityLootChance.get() && !statueStack.m_150930_(Items.f_42521_)) {
                CompoundTag entityTag = new CompoundTag();
                entityTag.m_128405_("statueLevel", 1);
                entityTag.m_128379_("statueUpgraded", true);
                entityTag.m_128405_("upgradeSlots", 20);
                entityTag.m_128405_("statueMobKilled", this.getRandInRange(context.m_230907_(), 6, 16));
                statueStack.m_41700_("BlockEntityTag", (Tag)entityTag);
                generatedLoot.add((Object)statueStack);
            }
        }
        return generatedLoot;
    }

    public int getRandInRange(RandomSource random, int min, int max) {
        return random.m_216332_(min, max);
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CODEC.get();
    }
}

