/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.items;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.compat.curios.CuriosCompat;
import com.shynieke.statues.registry.StatueTabs;
import com.shynieke.statues.util.UpgradeHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;

public class StatueBlockItem
extends BlockItem {
    public StatueBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder.m_41491_(StatueTabs.STATUES_BLOCKS));
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public boolean isBaby() {
        boolean bl;
        Block block = this.m_40614_();
        if (block instanceof AbstractStatueBase) {
            AbstractStatueBase statueBase = (AbstractStatueBase)block;
            bl = statueBase.isBaby();
        } else {
            bl = false;
        }
        return bl;
    }

    public EntityType<?> getEntity() {
        EntityType<?> entityType;
        Block block = this.m_40614_();
        if (block instanceof AbstractStatueBase) {
            AbstractStatueBase statueBase = (AbstractStatueBase)block;
            entityType = statueBase.getEntity();
        } else {
            entityType = null;
        }
        return entityType;
    }

    public boolean matchesEntity(LivingEntity livingEntity) {
        return this.getEntity() != null && this.getEntity() == livingEntity.m_6095_() && livingEntity.m_6162_() == this.isBaby();
    }

    @Nullable
    protected BlockState m_5965_(BlockPlaceContext context) {
        BlockState state = super.m_5965_(context);
        ItemStack stack = context.m_43722_();
        if (state != null && state.m_60734_() instanceof AbstractStatueBase && stack.m_41782_()) {
            CompoundTag compoundtag = stack.m_41737_("BlockEntityTag");
            if (compoundtag == null) {
                compoundtag = stack.m_41783_();
            }
            if (compoundtag != null && compoundtag.m_128471_("statueUpgraded")) {
                state = (BlockState)state.m_61124_((Property)AbstractStatueBase.INTERACTIVE, (Comparable)Boolean.valueOf(true));
            }
        }
        return state;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getCapability(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, components, tooltipFlag);
        CompoundTag blockData = stack.m_41737_("BlockEntityTag");
        if (blockData != null) {
            Map<String, Short> upgradeMap;
            if (blockData.m_128441_("statueLevel")) {
                components.add((Component)Component.m_237115_((String)"statues.info.level").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)String.valueOf(blockData.m_128451_("statueLevel"))).m_130940_(ChatFormatting.YELLOW)));
            }
            if (blockData.m_128441_("statueMobKilled")) {
                components.add((Component)Component.m_237115_((String)"statues.info.kills").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)String.valueOf(blockData.m_128451_("statueMobKilled"))).m_130940_(ChatFormatting.YELLOW)));
            }
            if (blockData.m_128441_("upgradeSlots")) {
                components.add((Component)Component.m_237115_((String)"statues.info.upgrade_slots").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)String.valueOf(blockData.m_128451_("upgradeSlots"))).m_130940_(ChatFormatting.YELLOW)));
            }
            if (!(upgradeMap = UpgradeHelper.loadUpgradeMap(blockData)).isEmpty()) {
                for (Map.Entry<String, Short> entry : upgradeMap.entrySet()) {
                    components.add(UpgradeHelper.getUpgradeName(entry.getKey(), entry.getValue().shortValue()));
                }
            }
        }
    }
}

