/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.Statues;
import com.shynieke.statues.fakeplayer.StatueFakePlayer;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.storage.StatueSavedData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StatueHandler {
    @SubscribeEvent
    public void onKill(LivingDeathEvent event) {
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (source instanceof Player) {
            Player player = (Player)source;
            Inventory inventory = player.m_150109_();
            for (int i = 0; i < inventory.m_6643_(); ++i) {
                Item item;
                ItemStack stack = inventory.m_8020_(i);
                if (stack.m_41613_() != 1 || !((item = stack.m_41720_()) instanceof StatueBlockItem)) continue;
                StatueBlockItem statue = (StatueBlockItem)item;
                if (!this.upgraded(stack) || !statue.matchesEntity(target)) continue;
                this.increaseKillCounter(stack);
                break;
            }
        }
    }

    private boolean upgraded(ItemStack stack) {
        return stack.m_41737_("BlockEntityTag") != null && stack.m_41737_("BlockEntityTag").m_128471_("statueUpgraded");
    }

    private void increaseKillCounter(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag == null) {
            Statues.LOGGER.error("Statue was incorrectly upgraded {}", (Object)stack);
            tag = new CompoundTag();
        }
        tag.m_128405_("statueMobKilled", tag.m_128451_("statueMobKilled") + 1);
        int level = this.getLevel(tag.m_128451_("statueMobKilled"));
        if (tag.m_128451_("statueLevel") != level) {
            tag.m_128405_("statueLevel", level);
            tag.m_128405_("upgradeSlots", tag.m_128451_("upgradeSlots") + 1);
        }
        stack.m_41700_("BlockEntityTag", (Tag)tag);
    }

    public int getLevel(int killedMobs) {
        if (killedMobs > 0) {
            int level = (int)Math.floor((double)killedMobs / 10.0);
            if (level <= 16) {
                return level;
            }
            return 16;
        }
        return 0;
    }

    @SubscribeEvent
    public void onLivingSpawnEvent(LivingSpawnEvent.CheckSpawn event) {
        MobSpawnType spawnReason = event.getSpawnReason();
        if (spawnReason == MobSpawnType.NATURAL || spawnReason == MobSpawnType.REINFORCEMENT || spawnReason == MobSpawnType.EVENT) {
            Mob mob = event.getEntity();
            if (StatueSavedData.get().isDespawnerNearby((ResourceKey<Level>)mob.f_19853_.m_46472_(), mob.m_20183_(), 32)) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            StatueFakePlayer.unload((LevelAccessor)serverLevel);
        }
    }
}

