/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.server.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shynieke.statues.recipe.StatuesRecipes;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class LootRecipeBuilder {
    private final Ingredient statueIngredient;
    private ItemStack result;
    private ItemStack result2;
    private ItemStack result3 = ItemStack.f_41583_;
    private float result1Chance = 1.0f;
    private float result2Chance = 0.5f;
    private float result3Chance = 0.1f;
    private String group;

    private LootRecipeBuilder(Ingredient statueIngredient) {
        this.statueIngredient = statueIngredient;
    }

    public static LootRecipeBuilder loot(Ingredient statueIngredient) {
        return new LootRecipeBuilder(statueIngredient);
    }

    public LootRecipeBuilder result1(ItemLike resultIn) {
        this.result = new ItemStack((ItemLike)resultIn.m_5456_());
        return this;
    }

    public LootRecipeBuilder result1(ItemStack resultIn) {
        this.result = resultIn;
        return this;
    }

    public LootRecipeBuilder result1(ItemLike resultIn, float chance) {
        this.result = new ItemStack((ItemLike)resultIn.m_5456_());
        this.result1Chance = chance;
        return this;
    }

    public LootRecipeBuilder result1(ItemStack resultIn, float chance) {
        this.result = resultIn;
        this.result1Chance = chance;
        return this;
    }

    public LootRecipeBuilder result2(ItemLike result2In) {
        this.result2 = new ItemStack((ItemLike)result2In.m_5456_());
        return this;
    }

    public LootRecipeBuilder result2(ItemStack result2In) {
        this.result2 = result2In;
        return this;
    }

    public LootRecipeBuilder result2(ItemLike result2In, float chance2) {
        this.result2 = new ItemStack((ItemLike)result2In.m_5456_());
        this.result2Chance = chance2;
        return this;
    }

    public LootRecipeBuilder result2(ItemStack result2In, float chance2) {
        this.result2 = result2In;
        this.result2Chance = chance2;
        return this;
    }

    public LootRecipeBuilder result3(ItemLike result3In) {
        this.result3 = new ItemStack((ItemLike)result3In.m_5456_());
        return this;
    }

    public LootRecipeBuilder result3(ItemStack result3In) {
        this.result3 = result3In;
        return this;
    }

    public LootRecipeBuilder result3(ItemLike result3In, float chance3) {
        this.result3 = new ItemStack((ItemLike)result3In.m_5456_());
        this.result3Chance = chance3;
        return this;
    }

    public LootRecipeBuilder result3(ItemStack result3In, float chance3) {
        this.result3 = result3In;
        this.result3Chance = chance3;
        return this;
    }

    public LootRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumerIn) {
        ResourceLocation itemKey = Registry.f_122827_.m_7981_((Object)this.statueIngredient.m_43908_()[0].m_41720_());
        this.build(consumerIn, new ResourceLocation(itemKey.m_135827_(), "loot/" + itemKey.m_135815_()));
    }

    public void build(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        consumerIn.accept(new Result(id, this.group == null ? "" : this.group, this.statueIngredient, this.result, this.result1Chance, this.result2, this.result2Chance, this.result3, this.result3Chance));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient statueIngredient;
        private final ItemStack result;
        private final ItemStack result2;
        private final ItemStack result3;
        private final float result1Chance;
        private final float result2Chance;
        private final float result3Chance;

        public Result(ResourceLocation idIn, String groupIn, Ingredient statueIngredient, ItemStack result, float result1Chance, ItemStack result2, float result2Chance, ItemStack result3, float result3Chance) {
            this.id = idIn;
            this.group = groupIn;
            this.statueIngredient = statueIngredient;
            this.result = result;
            this.result1Chance = result1Chance;
            this.result2 = result2;
            this.result2Chance = result2Chance;
            this.result3 = result3;
            this.result3Chance = result3Chance;
        }

        public void m_7917_(JsonObject json) {
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            json.add("ingredient", this.statueIngredient.m_43942_());
            this.addStack(json, "result1", this.result, this.result1Chance);
            this.addStack(json, "result2", this.result2, this.result2Chance);
            this.addStack(json, "result3", this.result3, this.result3Chance);
        }

        private void addStack(JsonObject json, String property, ItemStack stack, float chance) {
            if (stack != null && !stack.m_41619_()) {
                JsonObject object = new JsonObject();
                object.addProperty("item", Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString());
                if (stack.m_41613_() != 1) {
                    object.addProperty("count", (Number)stack.m_41613_());
                }
                if (stack.m_41782_()) {
                    object.addProperty("tag", stack.m_41783_().toString());
                }
                json.add(property, (JsonElement)object);
                json.addProperty(property + "Chance", (Number)Float.valueOf(chance));
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)StatuesRecipes.LOOT_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

