/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.server;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.EntityLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.RegistryObject;

public class StatueLootProvider
extends LootTableProvider {
    public StatueLootProvider(DataGenerator gen) {
        super(gen);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(StatueBlocks::new, (Object)LootContextParamSets.f_81421_), (Object)Pair.of(StatueEntities::new, (Object)LootContextParamSets.f_81415_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
        map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationtracker, (ResourceLocation)name, (LootTable)table));
    }

    private static class StatueEntities
    extends EntityLoot {
        private StatueEntities() {
        }

        protected void addTables() {
            this.m_124371_((EntityType)StatueRegistry.PLAYER_STATUE_ENTITY.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)StatueRegistry.STATUE_CORE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)1.0f)))).m_79080_(LootItemKilledByPlayerCondition.m_81901_())));
            this.m_124371_((EntityType)StatueRegistry.STATUE_BAT.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)StatueRegistry.STATUE_CORE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)))).m_79080_(LootItemKilledByPlayerCondition.m_81901_())));
        }

        protected boolean isNonLiving(EntityType<?> entitytype) {
            return false;
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            Stream<EntityType> entityTypeStream = StatueRegistry.ENTITIES.getEntries().stream().map(RegistryObject::get);
            return entityTypeStream::iterator;
        }
    }

    private static class StatueBlocks
    extends BlockLoot {
        private StatueBlocks() {
        }

        protected void addTables() {
            this.m_124175_((Block)StatueRegistry.PEBBLE.get(), block -> StatueBlocks.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolEntryContainer.Builder)StatueBlocks.m_236224_((ItemLike)block, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42484_).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.1f, 0.14285715f, 0.25f, 1.0f}))).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block))))));
            this.m_124288_((Block)StatueRegistry.DISPLAY_STAND.get());
            this.m_124288_((Block)StatueRegistry.SOMBRERO.get());
            this.m_124288_((Block)StatueRegistry.INFO_STATUE.get());
            this.m_124288_((Block)StatueRegistry.STATUE_TABLE.get());
            this.m_124165_((Block)StatueRegistry.PLAYER_STATUE.get(), StatueBlocks.m_124292_((Block)((Block)StatueRegistry.PLAYER_STATUE.get())));
            for (RegistryObject blockObject : StatueRegistry.BLOCKS.getEntries()) {
                if (!(blockObject.get() instanceof AbstractStatueBase)) continue;
                this.m_124288_((Block)blockObject.get());
            }
        }

        protected Iterable<Block> getKnownBlocks() {
            return StatueRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
        }
    }
}

