/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.jei;

import com.shynieke.statues.compat.jei.category.LootCategory;
import com.shynieke.statues.compat.jei.category.UpgradeCategory;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeRecipe;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.Objects;
import javax.annotation.Nullable;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public static final ResourceLocation PLUGIN_UID = new ResourceLocation("statues", "main");
    public static final ResourceLocation LOOT_BACKGROUND = new ResourceLocation("statues", "textures/gui/jei/loot.png");
    public static final RecipeType<LootRecipe> LOOT_TYPE = RecipeType.create((String)"statues", (String)"loot", LootRecipe.class);
    public static final ResourceLocation UPGRADE_BACKGROUND = new ResourceLocation("statues", "textures/gui/jei/upgrade.png");
    public static final RecipeType<UpgradeRecipe> UPGRADE_TYPE = RecipeType.create((String)"statues", (String)"upgrade", UpgradeRecipe.class);
    @Nullable
    private IRecipeCategory<LootRecipe> lootCategory;
    @Nullable
    private IRecipeCategory<UpgradeRecipe> upgradeCategory;

    public ResourceLocation getPluginUid() {
        return PLUGIN_UID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()), new RecipeType[]{LOOT_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()), new RecipeType[]{UPGRADE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IRecipeCategory[] iRecipeCategoryArray = new IRecipeCategory[2];
        this.lootCategory = new LootCategory(guiHelper);
        iRecipeCategoryArray[0] = this.lootCategory;
        this.upgradeCategory = new UpgradeCategory(guiHelper);
        iRecipeCategoryArray[1] = this.upgradeCategory;
        registration.addRecipeCategories(iRecipeCategoryArray);
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel clientLevel = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(LOOT_TYPE, clientLevel.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)StatuesRecipes.LOOT_RECIPE.get()));
        registration.addRecipes(UPGRADE_TYPE, clientLevel.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)StatuesRecipes.UPGRADE_RECIPE.get()));
    }
}

