/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.google.common.collect.ImmutableList;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.registry.StatueSounds;
import com.shynieke.statues.util.ListHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CampfireStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)7.0, (double)16.0);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)7.0, (double)11.0);
    public static final List<Supplier<SoundEvent>> campfire_sounds = ImmutableList.of(StatueSounds.CAMPFIRE_BYE_RANDOM, StatueSounds.CAMPFIRE_COLD_RANDOM, StatueSounds.CAMPFIRE_GREETINGS_RANDOM, StatueSounds.CAMPFIRE_HELLO_RANDOM, StatueSounds.CAMPFIRE_SNACKS_RANDOM);

    public CampfireStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.m_60918_(SoundType.f_56742_).m_60953_(state -> 12));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return direction.m_122434_() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return CampfireStatueBlock.getRandomCampfire();
    }

    @Override
    public LivingEntity adjustSpawnedEntity(LivingEntity livingEntity) {
        if (livingEntity instanceof Creeper) {
            Creeper general = (Creeper)livingEntity;
            general.m_6593_((Component)Component.m_237113_((String)"General Spazz"));
            CompoundTag tag = new CompoundTag();
            tag.m_128344_("ExplosionRadius", (byte)0);
            general.m_7380_(tag);
            return general;
        }
        return livingEntity;
    }

    public static SoundEvent getRandomCampfire() {
        return ListHelper.getRandomFromList(campfire_sounds).get();
    }

    @Override
    public boolean isHiddenStatue() {
        return true;
    }
}

