/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.shynieke.statues.Statues;
import com.shynieke.statues.menu.StatueTableMenu;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeRecipe;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueTags;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class StatueTableBlockEntity
extends BlockEntity
implements MenuProvider {
    public int time;
    public static final int SLOT_CENTER = 0;
    public static final int SLOT_CORE = 1;
    public static final int[] SLOT_CATALYSTS = new int[]{2, 3, 4, 5};
    protected UpgradeRecipe currentRecipe;
    public final ItemStackHandler handler = new ItemStackHandler(6){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            if (slot == 0 || slot == 1) {
                return 1;
            }
            return 64;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.m_204117_(StatueTags.UPGRADEABLE_STATUES);
            }
            if (slot == 1) {
                return stack.m_204117_(StatueTags.STATUE_CORE);
            }
            return super.isItemValid(slot, stack);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            StatueTableBlockEntity.this.refreshClient();
        }
    };
    private LazyOptional<IItemHandler> stackHolder = LazyOptional.of(() -> this.handler);

    public StatueTableBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public StatueTableBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)StatueBlockEntities.STATUE_TABLE.get(), pos, state);
    }

    protected void updateCachedRecipe() {
        if (this.getCenterSlot().m_41619_()) {
            this.currentRecipe = null;
            return;
        }
        SimpleContainer container = new SimpleContainer(6);
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            container.m_6836_(i, this.handler.getStackInSlot(i));
        }
        this.currentRecipe = this.f_58857_.m_7465_().m_44015_((RecipeType)StatuesRecipes.UPGRADE_RECIPE.get(), (Container)container, this.f_58857_).orElse(null);
    }

    public boolean hasValidRecipe() {
        return this.currentRecipe != null;
    }

    public void executeCraft() {
        if (this.hasValidRecipe()) {
            if (this.currentRecipe.requiresCore()) {
                this.getCoreSlot().m_41774_(1);
            }
            for (int slot : SLOT_CATALYSTS) {
                this.handler.getStackInSlot(slot).m_41774_(1);
            }
            ItemStack resultStack = this.currentRecipe.m_8043_().m_41777_();
            ItemStack centerStack = this.getCenterSlot();
            if (resultStack.m_41619_()) {
                if (!this.currentRecipe.getUpgradeType().apply(centerStack, this.currentRecipe.getTier())) {
                    Statues.LOGGER.debug("Failed to apply upgrade {} to {}", (Object)this.currentRecipe.m_6423_(), (Object)resultStack);
                    this.currentRecipe = null;
                    return;
                }
            } else {
                centerStack.m_41774_(1);
                this.handler.setStackInSlot(0, resultStack);
            }
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11671_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.updateCachedRecipe();
        this.refreshClient();
    }

    public ItemStack getCenterSlot() {
        return this.handler.getStackInSlot(0);
    }

    public ItemStack getCoreSlot() {
        return this.handler.getStackInSlot(1);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.handler.deserializeNBT(compound.m_128469_("ItemStackHandler"));
        this.updateCachedRecipe();
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("ItemStackHandler", (Tag)this.handler.serializeNBT());
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public static void renderTick(Level level, BlockPos pos, BlockState state, StatueTableBlockEntity tableBlockEntity) {
        ++tableBlockEntity.time;
    }

    private void refreshClient() {
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
        this.updateCachedRecipe();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StatueTableBlockEntity tableBlockEntity) {
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"statues.container.statue_table");
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new StatueTableMenu(id, inventory, this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.stackHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.stackHolder.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.stackHolder = LazyOptional.of(() -> this.handler);
    }
}

