/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.storage.StatueSavedData;
import com.shynieke.statues.util.UpgradeHelper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;

public abstract class AbstractStatueBlockEntity
extends BlockEntity {
    private final Map<String, Short> upgradeMap = new HashMap<String, Short>();
    public int cooldown = 200;
    public int interactCooldown = 200;
    public boolean statueAble = false;
    public boolean statueInteractable = false;
    public boolean statueUpgraded;
    private int mobKilled;
    private int statueLevel;
    private int upgradeSlots;
    public static final int[] DYE_COLORS = new int[]{0x1E1B1B, 11743532, 3887386, 5320730, 2437522, 8073150, 2651799, 0xABABAB, 0x434343, 14188952, 4312372, 14602026, 6719955, 12801229, 15435844, 0xF0F0F0};

    protected AbstractStatueBlockEntity(BlockEntityType<?> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.cooldown = compound.m_128451_("StatueCooldown");
        this.interactCooldown = compound.m_128451_("InteractionCooldown");
        this.statueAble = compound.m_128471_("StatueAble");
        this.statueInteractable = compound.m_128471_("StatueInteractable");
        this.loadFromNbt(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("StatueCooldown", this.cooldown);
        compound.m_128405_("InteractionCooldown", this.interactCooldown);
        compound.m_128379_("StatueAble", this.statueAble);
        compound.m_128379_("StatueInteractable", this.statueInteractable);
        this.saveToNbt(compound);
    }

    public void m_187476_(ItemStack stack) {
        CompoundTag compound = this.m_187482_();
        compound.m_128473_("StatueCooldown");
        compound.m_128473_("InteractionCooldown");
        compound.m_128473_("StatueAble");
        compound.m_128473_("StatueInteractable");
        BlockItem.m_186338_((ItemStack)stack, (BlockEntityType)this.m_58903_(), (CompoundTag)compound);
    }

    public void onLoad() {
        super.onLoad();
        if (this.f_58857_ != null && this.isDespawner()) {
            StatueSavedData.get().addPosition((ResourceKey<Level>)this.f_58857_.m_46472_(), this.m_58899_());
        }
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.f_58857_ != null && this.isDespawner()) {
            StatueSavedData.get().removePosition((ResourceKey<Level>)this.f_58857_.m_46472_(), this.m_58899_());
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        this.f_58857_.m_7260_(this.m_58899_(), state, state, 3);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public CompoundTag getPersistentData() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getInteractCooldown() {
        return this.interactCooldown;
    }

    public int getStatueLevel() {
        return this.statueLevel;
    }

    public boolean isStatueAble() {
        return this.statueAble;
    }

    public void setStatueAble(boolean statueAble) {
        this.statueAble = statueAble;
        this.m_6596_();
    }

    public boolean isStatueInteractable() {
        return this.statueInteractable;
    }

    public void setStatueInteractable(boolean interactable) {
        this.statueInteractable = interactable;
        this.m_6596_();
    }

    public void loadFromNbt(CompoundTag compound) {
        this.statueUpgraded = compound.m_128471_("statueUpgraded");
        this.mobKilled = compound.m_128451_("statueMobKilled");
        this.statueLevel = compound.m_128451_("statueLevel");
        this.upgradeSlots = compound.m_128451_("upgradeSlots");
        this.upgradeMap.clear();
        this.upgradeMap.putAll(UpgradeHelper.loadUpgradeMap(compound));
    }

    public CompoundTag saveToNbt(CompoundTag compound) {
        this.saveUpgrades(compound);
        return compound;
    }

    public CompoundTag saveUpgrades(CompoundTag tag) {
        tag.m_128379_("statueUpgraded", this.statueUpgraded);
        tag.m_128405_("statueMobKilled", this.mobKilled);
        tag.m_128405_("statueLevel", this.statueLevel);
        tag.m_128405_("upgradeSlots", this.upgradeSlots);
        UpgradeHelper.saveUpgradeMap(tag, this.upgradeMap);
        return tag;
    }

    protected void refreshClient() {
        this.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 2);
    }

    public Map<String, Short> getUpgradeMap() {
        return this.upgradeMap;
    }

    public boolean isDecorative() {
        return !this.upgradeMap.isEmpty();
    }

    public boolean hasUpgrade(String id) {
        return this.upgradeMap.containsKey(id);
    }

    public int getUpgradeLevel(String id) {
        return this.upgradeMap.getOrDefault(id, (short)-1).shortValue();
    }

    public boolean makesSounds() {
        return this.hasUpgrade("sound");
    }

    public boolean isSpawner() {
        return this.hasUpgrade("spawner");
    }

    public boolean isKiller() {
        return this.hasUpgrade("mob_killer");
    }

    public boolean isDespawner() {
        return this.hasUpgrade("despawner");
    }

    public int getSpawnerLevel() {
        return this.getUpgradeLevel("spawner");
    }

    public boolean hasSpecialInteraction() {
        return this.hasUpgrade("interaction");
    }

    public boolean canDropLoot() {
        return this.hasUpgrade("looting");
    }

    public boolean canAutomate() {
        return this.hasUpgrade("automation");
    }

    public int getSpeed() {
        return this.hasUpgrade("speed") ? this.getUpgradeLevel("speed") + 1 : 0;
    }

    public InteractionResult interact(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, BlockHitResult result) {
        return InteractionResult.PASS;
    }

    public AbstractStatueBase getStatue() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AbstractStatueBase) {
            AbstractStatueBase statueBase = (AbstractStatueBase)block;
            return statueBase;
        }
        return null;
    }

    public void playSound(SoundEvent sound, BlockPos pos) {
        this.playSound(sound, pos, 1.0f);
    }

    public void playSound(SoundEvent sound, BlockPos pos, float pitch) {
        this.f_58857_.m_5594_(null, pos, sound, SoundSource.NEUTRAL, 1.0f, pitch);
    }

    public ItemStack getFirework(RandomSource rand) {
        ItemStack firework = new ItemStack((ItemLike)Items.f_42688_);
        firework.m_41784_();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128379_("Flicker", true);
        nbt.m_128379_("Trail", true);
        int[] colors = new int[rand.m_188503_(8) + 1];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DYE_COLORS[rand.m_188503_(16)];
        }
        nbt.m_128385_("Colors", colors);
        byte type = (byte)(rand.m_188503_(3) + 1);
        type = type == 3 ? (byte)4 : (byte)type;
        nbt.m_128344_("Type", type);
        ListTag explosions = new ListTag();
        explosions.add((Object)nbt);
        CompoundTag fireworkTag = new CompoundTag();
        fireworkTag.m_128365_("Explosions", (Tag)explosions);
        fireworkTag.m_128344_("Flight", (byte)1);
        CompoundTag stackTag = firework.m_41784_();
        stackTag.m_128365_("Fireworks", (Tag)fireworkTag);
        firework.m_41751_(stackTag);
        return firework;
    }

    protected class BiggestInventory
    implements Comparable<BiggestInventory> {
        private final int inventorySize;
        private final BlockPos tilePos;
        private final Direction direction;

        public BiggestInventory(BlockPos pos, int size, Direction dir) {
            this.tilePos = pos;
            this.inventorySize = size;
            this.direction = dir;
        }

        protected IItemHandler getIItemHandler(Level level) {
            BlockEntity blockEntity;
            if (level.isAreaLoaded(AbstractStatueBlockEntity.this.f_58858_, 1) && !(blockEntity = level.m_7702_(this.tilePos)).m_58901_() && blockEntity.m_58898_() && blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent()) {
                return (IItemHandler)blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, this.direction).orElse(null);
            }
            return null;
        }

        @Override
        public int compareTo(BiggestInventory otherInventory) {
            return Integer.compare(this.inventorySize, otherInventory.inventorySize);
        }
    }
}

