/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.smoothboot.mixin;

import com.abdelaziz.smoothboot.SmoothBoot;
import com.abdelaziz.smoothboot.config.SmoothBootConfig;
import com.abdelaziz.smoothboot.config.SmoothBootConfigHandler;
import com.abdelaziz.smoothboot.util.LoggingForkJoinWorkerThread;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.util.Mth;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Util.class})
public abstract class UtilMixin {
    private static boolean initBootstrapExecutor = false;
    private static boolean initMainWorkerExecutor = false;
    @Shadow
    @Final
    static Logger f_137446_;
    private static boolean initIoWorker;
    @Shadow
    @Final
    @Mutable
    private static ExecutorService f_137443_;
    @Shadow
    @Final
    @Mutable
    private static ExecutorService f_137444_;
    @Shadow
    @Final
    @Mutable
    private static ExecutorService f_137445_;
    @Shadow
    @Final
    private static AtomicInteger f_137442_;

    @Shadow
    private static void m_137495_(Thread thread, Throwable throwable) {
    }

    @Inject(method={"bootstrapExecutor"}, at={@At(value="HEAD")})
    private static void onGetBootstrapExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!initBootstrapExecutor) {
            f_137443_ = UtilMixin.replWorker("Bootstrap");
            initBootstrapExecutor = true;
            SmoothBoot.LOGGER.debug("Replaced Bootstrap Executor");
        }
    }

    @Inject(method={"backgroundExecutor"}, at={@At(value="HEAD")})
    private static void onGetMainWorkerExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!initMainWorkerExecutor) {
            f_137444_ = UtilMixin.replWorker("Main");
            initMainWorkerExecutor = true;
            SmoothBoot.LOGGER.debug("Replaced Main Executor");
        }
    }

    @Inject(method={"ioPool"}, at={@At(value="HEAD")})
    private static void onGetIoWorkerExecutor(CallbackInfoReturnable<Executor> ci) {
        if (!initIoWorker) {
            f_137445_ = UtilMixin.replIoWorker();
            initIoWorker = true;
            SmoothBoot.LOGGER.debug("Replaced IO Executor");
        }
    }

    private static ExecutorService replWorker(String name) {
        if (SmoothBootConfigHandler.config == null) {
            try {
                SmoothBootConfigHandler.readConfig();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        SmoothBootConfig config = SmoothBootConfigHandler.config;
        ForkJoinPool executorService2 = new ForkJoinPool(Mth.m_14045_((int)UtilMixin.select(name, config.getBootstrapThreads(), config.getMainThreads()), (int)1, (int)Short.MAX_VALUE), forkJoinPool -> {
            String workerName = "Worker-" + name + f_137442_.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            LoggingForkJoinWorkerThread forkJoinWorkerThread = new LoggingForkJoinWorkerThread(forkJoinPool, f_137446_);
            forkJoinWorkerThread.setPriority(UtilMixin.select(name, config.getBootstrapPriority(), config.getMainPriority()));
            forkJoinWorkerThread.setName(workerName);
            return forkJoinWorkerThread;
        }, UtilMixin::m_137495_, true);
        return executorService2;
    }

    private static ExecutorService replIoWorker() {
        return Executors.newCachedThreadPool(p_240978_0_ -> {
            String workerName = "IO-Worker-" + f_137442_.getAndIncrement();
            SmoothBoot.LOGGER.debug("Initialized " + workerName);
            Thread thread = new Thread(p_240978_0_);
            thread.setName(workerName);
            thread.setPriority(SmoothBootConfigHandler.config.getIoPriority());
            thread.setUncaughtExceptionHandler(UtilMixin::m_137495_);
            return thread;
        });
    }

    private static <T> T select(String name, T bootstrap, T main) {
        return Objects.equal((Object)name, (Object)"Bootstrap") ? bootstrap : main;
    }

    static {
        initIoWorker = false;
    }
}

