/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.charginggadgets.blocks.chargingstation;

import com.direwolf20.charginggadgets.blocks.BlockRegistry;
import com.direwolf20.charginggadgets.blocks.chargingstation.ChargingStationTile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ChargingStationContainer
extends AbstractContainerMenu {
    private static final int SLOTS = 2;
    public final ContainerData data;
    public ItemStackHandler handler;
    private ChargingStationTile tile;

    public ChargingStationContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this((ChargingStationTile)playerInventory.f_35978_.f_19853_.m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(4), windowId, playerInventory, new ItemStackHandler(2));
    }

    public ChargingStationContainer(@Nullable ChargingStationTile tile, ContainerData chargingStationData, int windowId, Inventory playerInventory, ItemStackHandler handler) {
        super((MenuType)BlockRegistry.CHARGING_STATION_CONTAINER.get(), windowId);
        this.handler = handler;
        this.tile = tile;
        this.data = chargingStationData;
        this.setup(playerInventory);
        this.m_38884_(chargingStationData);
    }

    public void setup(Inventory inventory) {
        int row;
        this.m_38897_((Slot)new RestrictedSlot((IItemHandler)this.handler, 0, 65, 43));
        this.m_38897_((Slot)new RestrictedSlot((IItemHandler)this.handler, 1, 119, 43));
        for (row = 0; row < 9; ++row) {
            int x = 8 + row * 18;
            int y = 142;
            this.m_38897_(new Slot((Container)inventory, row, x, y));
        }
        for (row = 1; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = 8 + col * 18;
                int y = row * 18 + 66;
                this.m_38897_(new Slot((Container)inventory, col + row * 9, x, y));
            }
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack currentStack = slot.m_7993_();
            itemstack = currentStack.m_41777_();
            if (index < 2 ? !this.m_38903_(currentStack, 2, this.f_38839_.size(), false) : !this.m_38903_(currentStack, 0, 2, false)) {
                return ItemStack.f_41583_;
            }
            if (currentStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6875_(Player playerIn) {
        BlockPos pos = this.tile.m_58899_();
        if (this.tile == null) return false;
        if (this.tile.m_58901_()) return false;
        Vec3 vec3 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (!(playerIn.m_20238_(vec3.m_82520_(0.5, 0.5, 0.5)) <= 64.0)) return false;
        return true;
    }

    public int getMaxPower() {
        return this.data.m_6413_(1) * 32;
    }

    public int getEnergy() {
        return this.data.m_6413_(0) * 32;
    }

    public int getMaxBurn() {
        return this.data.m_6413_(3);
    }

    public int getRemaining() {
        return this.data.m_6413_(2);
    }

    static class RestrictedSlot
    extends SlotItemHandler {
        public RestrictedSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            if (this.getSlotIndex() == ChargingStationTile.Slots.CHARGE.getId()) {
                return stack.getCapability(CapabilityEnergy.ENERGY).isPresent();
            }
            if (this.getSlotIndex() == ChargingStationTile.Slots.FUEL.getId()) {
                return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) != 0;
            }
            return super.m_5857_(stack);
        }
    }
}

